; This file was created with EvAVRbuilder.dll library. 12.12.2020 14:22:38

//-- device --
;***** THIS IS A MACHINE GENERATED FILE - DO NOT EDIT ********************
;***** Created: 2011-08-25 21:00 ******* Source: ATmega8A.xml ************
;*************************************************************************
;* A P P L I C A T I O N   N O T E   F O R   T H E   A V R   F A M I L Y
;* 
;* Number            : AVR000
;* File Name         : "m8Adef.inc"
;* Title             : Register/Bit Definitions for the ATmega8A
;* Date              : 2011-08-25
;* Version           : 2.35
;* Support E-mail    : avr@atmel.com
;* Target MCU        : ATmega8A
;* 
;* DESCRIPTION
;* When including this file in the assembly program file, all I/O register 
;* names and I/O register bit names appearing in the data book can be used.
;* In addition, the six registers forming the three data pointers X, Y and 
;* Z have been assigned names XL - ZH. Highest RAM address for Internal 
;* SRAM is also defined 
;* 
;* The Register names are represented by their hexadecimal address.
;* 
;* The Register Bit names are represented by their bit number (0-7).
;* 
;* Please observe the difference in using the bit names with instructions
;* such as "sbr"/"cbr" (set/clear bit in register) and "sbrs"/"sbrc"
;* (skip if bit in register set/cleared). The following example illustrates
;* this:
;* 
;* in    r16,PORTB             ;read PORTB latch
;* sbr   r16,(1<<PB6)+(1<<PB5) ;set PB6 and PB5 (use masks, not bit#)
;* out   PORTB,r16             ;output to PORTB
;* 
;* in    r16,TIFR              ;read the Timer Interrupt Flag Register
;* sbrc  r16,TOV0              ;test the overflow flag (use bit#)
;* rjmp  TOV0_is_set           ;jump if set
;* ...                         ;otherwise do something else
;*************************************************************************

#ifndef _M8ADEF_INC_
#define _M8ADEF_INC_


#pragma partinc 0

; ***** SPECIFY DEVICE ***************************************************
.device ATmega8A
#pragma AVRPART ADMIN PART_NAME ATmega8A
.equ	SIGNATURE_000	= 0x1e
.equ	SIGNATURE_001	= 0x93
.equ	SIGNATURE_002	= 0x07

#pragma AVRPART CORE CORE_VERSION V2E


; ***** I/O REGISTER DEFINITIONS *****************************************
; NOTE:
; Definitions marked "MEMORY MAPPED"are extended I/O ports
; and cannot be used with IN/OUT instructions
.equ	SREG	= 0x3f
.equ	SPL	= 0x3d
.equ	SPH	= 0x3e
.equ	GICR	= 0x3b
.equ	GIFR	= 0x3a
.equ	TIMSK	= 0x39
.equ	TIFR	= 0x38
.equ	SPMCR	= 0x37
.equ	TWCR	= 0x36
.equ	MCUCR	= 0x35
.equ	MCUCSR	= 0x34
.equ	TCCR0	= 0x33
.equ	TCNT0	= 0x32
.equ	OSCCAL	= 0x31
.equ	SFIOR	= 0x30
.equ	TCCR1A	= 0x2f
.equ	TCCR1B	= 0x2e
.equ	TCNT1L	= 0x2c
.equ	TCNT1H	= 0x2d
.equ	OCR1AL	= 0x2a
.equ	OCR1AH	= 0x2b
.equ	OCR1BL	= 0x28
.equ	OCR1BH	= 0x29
.equ	ICR1L	= 0x26
.equ	ICR1H	= 0x27
.equ	TCCR2	= 0x25
.equ	TCNT2	= 0x24
.equ	OCR2	= 0x23
.equ	ASSR	= 0x22
.equ	WDTCR	= 0x21
.equ	UBRRH	= 0x20
.equ	UCSRC	= 0x20
.equ	EEARL	= 0x1e
.equ	EEARH	= 0x1f
.equ	EEDR	= 0x1d
.equ	EECR	= 0x1c
.equ	PORTB	= 0x18
.equ	DDRB	= 0x17
.equ	PINB	= 0x16
.equ	PORTC	= 0x15
.equ	DDRC	= 0x14
.equ	PINC	= 0x13
.equ	PORTD	= 0x12
.equ	DDRD	= 0x11
.equ	PIND	= 0x10
.equ	SPDR	= 0x0f
.equ	SPSR	= 0x0e
.equ	SPCR	= 0x0d
.equ	UDR	= 0x0c
.equ	UCSRA	= 0x0b
.equ	UCSRB	= 0x0a
.equ	UBRRL	= 0x09
.equ	ACSR	= 0x08
.equ	ADMUX	= 0x07
.equ	ADCSRA	= 0x06
.equ	ADCL	= 0x04
.equ	ADCH	= 0x05
.equ	TWDR	= 0x03
.equ	TWAR	= 0x02
.equ	TWSR	= 0x01
.equ	TWBR	= 0x00


; ***** BIT DEFINITIONS **************************************************

; ***** ANALOG_COMPARATOR ************
; SFIOR - Special Function IO Register
.equ	ACME	= 3	; Analog Comparator Multiplexer Enable

; ACSR - Analog Comparator Control And Status Register
.equ	ACIS0	= 0	; Analog Comparator Interrupt Mode Select bit 0
.equ	ACIS1	= 1	; Analog Comparator Interrupt Mode Select bit 1
.equ	ACIC	= 2	; Analog Comparator Input Capture Enable
.equ	ACIE	= 3	; Analog Comparator Interrupt Enable
.equ	ACI	= 4	; Analog Comparator Interrupt Flag
.equ	ACO	= 5	; Analog Compare Output
.equ	ACBG	= 6	; Analog Comparator Bandgap Select
.equ	ACD	= 7	; Analog Comparator Disable


; ***** SPI **************************
; SPDR - SPI Data Register
.equ	SPDR0	= 0	; SPI Data Register bit 0
.equ	SPDR1	= 1	; SPI Data Register bit 1
.equ	SPDR2	= 2	; SPI Data Register bit 2
.equ	SPDR3	= 3	; SPI Data Register bit 3
.equ	SPDR4	= 4	; SPI Data Register bit 4
.equ	SPDR5	= 5	; SPI Data Register bit 5
.equ	SPDR6	= 6	; SPI Data Register bit 6
.equ	SPDR7	= 7	; SPI Data Register bit 7

; SPSR - SPI Status Register
.equ	SPI2X	= 0	; Double SPI Speed Bit
.equ	WCOL	= 6	; Write Collision Flag
.equ	SPIF	= 7	; SPI Interrupt Flag

; SPCR - SPI Control Register
.equ	SPR0	= 0	; SPI Clock Rate Select 0
.equ	SPR1	= 1	; SPI Clock Rate Select 1
.equ	CPHA	= 2	; Clock Phase
.equ	CPOL	= 3	; Clock polarity
.equ	MSTR	= 4	; Master/Slave Select
.equ	DORD	= 5	; Data Order
.equ	SPE	= 6	; SPI Enable
.equ	SPIE	= 7	; SPI Interrupt Enable


; ***** EXTERNAL_INTERRUPT ***********
; GICR - General Interrupt Control Register
.equ	GIMSK	= GICR	; For compatibility
.equ	IVCE	= 0	; Interrupt Vector Change Enable
.equ	IVSEL	= 1	; Interrupt Vector Select
.equ	INT0	= 6	; External Interrupt Request 0 Enable
.equ	INT1	= 7	; External Interrupt Request 1 Enable

; GIFR - General Interrupt Flag Register
.equ	INTF0	= 6	; External Interrupt Flag 0
.equ	INTF1	= 7	; External Interrupt Flag 1

; MCUCR - MCU Control Register
.equ	ISC00	= 0	; Interrupt Sense Control 0 Bit 0
.equ	ISC01	= 1	; Interrupt Sense Control 0 Bit 1
.equ	ISC10	= 2	; Interrupt Sense Control 1 Bit 0
.equ	ISC11	= 3	; Interrupt Sense Control 1 Bit 1


; ***** TIMER_COUNTER_0 **************
; TIMSK - Timer/Counter Interrupt Mask Register
.equ	TOIE0	= 0	; Timer/Counter0 Overflow Interrupt Enable

; TIFR - Timer/Counter Interrupt Flag register
.equ	TOV0	= 0	; Timer/Counter0 Overflow Flag

; TCCR0 - Timer/Counter0 Control Register
.equ	CS00	= 0	; Clock Select0 bit 0
.equ	CS01	= 1	; Clock Select0 bit 1
.equ	CS02	= 2	; Clock Select0 bit 2

; TCNT0 - Timer Counter 0
.equ	TCNT00	= 0	; Timer Counter 0 bit 0
.equ	TCNT01	= 1	; Timer Counter 0 bit 1
.equ	TCNT02	= 2	; Timer Counter 0 bit 2
.equ	TCNT03	= 3	; Timer Counter 0 bit 3
.equ	TCNT04	= 4	; Timer Counter 0 bit 4
.equ	TCNT05	= 5	; Timer Counter 0 bit 5
.equ	TCNT06	= 6	; Timer Counter 0 bit 6
.equ	TCNT07	= 7	; Timer Counter 0 bit 7


; ***** TIMER_COUNTER_1 **************
; TIMSK - Timer/Counter Interrupt Mask Register
.equ	TOIE1	= 2	; Timer/Counter1 Overflow Interrupt Enable
.equ	OCIE1B	= 3	; Timer/Counter1 Output CompareB Match Interrupt Enable
.equ	OCIE1A	= 4	; Timer/Counter1 Output CompareA Match Interrupt Enable
.equ	TICIE1	= 5	; Timer/Counter1 Input Capture Interrupt Enable

; TIFR - Timer/Counter Interrupt Flag register
.equ	TOV1	= 2	; Timer/Counter1 Overflow Flag
.equ	OCF1B	= 3	; Output Compare Flag 1B
.equ	OCF1A	= 4	; Output Compare Flag 1A
.equ	ICF1	= 5	; Input Capture Flag 1

; TCCR1A - Timer/Counter1 Control Register A
.equ	WGM10	= 0	; Waveform Generation Mode
.equ	PWM10	= WGM10	; For compatibility
.equ	WGM11	= 1	; Waveform Generation Mode
.equ	PWM11	= WGM11	; For compatibility
.equ	FOC1B	= 2	; Force Output Compare 1B
.equ	FOC1A	= 3	; Force Output Compare 1A
.equ	COM1B0	= 4	; Compare Output Mode 1B, bit 0
.equ	COM1B1	= 5	; Compare Output Mode 1B, bit 1
.equ	COM1A0	= 6	; Compare Ouput Mode 1A, bit 0
.equ	COM1A1	= 7	; Compare Output Mode 1A, bit 1

; TCCR1B - Timer/Counter1 Control Register B
.equ	CS10	= 0	; Prescaler source of Timer/Counter 1
.equ	CS11	= 1	; Prescaler source of Timer/Counter 1
.equ	CS12	= 2	; Prescaler source of Timer/Counter 1
.equ	WGM12	= 3	; Waveform Generation Mode
.equ	CTC10	= WGM12	; For compatibility
.equ	CTC1	= WGM12	; For compatibility
.equ	WGM13	= 4	; Waveform Generation Mode
.equ	CTC11	= WGM13	; For compatibility
.equ	ICES1	= 6	; Input Capture 1 Edge Select
.equ	ICNC1	= 7	; Input Capture 1 Noise Canceler


; ***** TIMER_COUNTER_2 **************
; TIMSK - Timer/Counter Interrupt Mask register
.equ	TOIE2	= 6	; Timer/Counter2 Overflow Interrupt Enable
.equ	OCIE2	= 7	; Timer/Counter2 Output Compare Match Interrupt Enable

; TIFR - Timer/Counter Interrupt Flag Register
.equ	TOV2	= 6	; Timer/Counter2 Overflow Flag
.equ	OCF2	= 7	; Output Compare Flag 2

; TCCR2 - Timer/Counter2 Control Register
.equ	CS20	= 0	; Clock Select bit 0
.equ	CS21	= 1	; Clock Select bit 1
.equ	CS22	= 2	; Clock Select bit 2
.equ	WGM21	= 3	; Waveform Generation Mode
.equ	CTC2	= WGM21	; For compatibility
.equ	COM20	= 4	; Compare Output Mode bit 0
.equ	COM21	= 5	; Compare Output Mode bit 1
.equ	WGM20	= 6	; Waveform Genration Mode
.equ	PWM2	= WGM20	; For compatibility
.equ	FOC2	= 7	; Force Output Compare

; TCNT2 - Timer/Counter2
.equ	TCNT2_0	= 0	; Timer/Counter 2 bit 0
.equ	TCNT2_1	= 1	; Timer/Counter 2 bit 1
.equ	TCNT2_2	= 2	; Timer/Counter 2 bit 2
.equ	TCNT2_3	= 3	; Timer/Counter 2 bit 3
.equ	TCNT2_4	= 4	; Timer/Counter 2 bit 4
.equ	TCNT2_5	= 5	; Timer/Counter 2 bit 5
.equ	TCNT2_6	= 6	; Timer/Counter 2 bit 6
.equ	TCNT2_7	= 7	; Timer/Counter 2 bit 7

; OCR2 - Timer/Counter2 Output Compare Register
.equ	OCR2_0	= 0	; Timer/Counter2 Output Compare Register Bit 0
.equ	OCR2_1	= 1	; Timer/Counter2 Output Compare Register Bit 1
.equ	OCR2_2	= 2	; Timer/Counter2 Output Compare Register Bit 2
.equ	OCR2_3	= 3	; Timer/Counter2 Output Compare Register Bit 3
.equ	OCR2_4	= 4	; Timer/Counter2 Output Compare Register Bit 4
.equ	OCR2_5	= 5	; Timer/Counter2 Output Compare Register Bit 5
.equ	OCR2_6	= 6	; Timer/Counter2 Output Compare Register Bit 6
.equ	OCR2_7	= 7	; Timer/Counter2 Output Compare Register Bit 7

; ASSR - Asynchronous Status Register
.equ	TCR2UB	= 0	; Timer/counter Control Register2 Update Busy
.equ	OCR2UB	= 1	; Output Compare Register2 Update Busy
.equ	TCN2UB	= 2	; Timer/Counter2 Update Busy
.equ	AS2	= 3	; Asynchronous Timer/counter2

; SFIOR - Special Function IO Register
.equ	PSR2	= 1	; Prescaler Reset Timer/Counter2


; ***** USART ************************
; UDR - USART I/O Data Register
.equ	UDR0	= 0	; USART I/O Data Register bit 0
.equ	UDR1	= 1	; USART I/O Data Register bit 1
.equ	UDR2	= 2	; USART I/O Data Register bit 2
.equ	UDR3	= 3	; USART I/O Data Register bit 3
.equ	UDR4	= 4	; USART I/O Data Register bit 4
.equ	UDR5	= 5	; USART I/O Data Register bit 5
.equ	UDR6	= 6	; USART I/O Data Register bit 6
.equ	UDR7	= 7	; USART I/O Data Register bit 7

; UCSRA - USART Control and Status Register A
.equ	USR	= UCSRA	; For compatibility
.equ	MPCM	= 0	; Multi-processor Communication Mode
.equ	U2X	= 1	; Double the USART transmission speed
.equ	UPE	= 2	; Parity Error
.equ	PE	= UPE	; For compatibility
.equ	DOR	= 3	; Data overRun
.equ	FE	= 4	; Framing Error
.equ	UDRE	= 5	; USART Data Register Empty
.equ	TXC	= 6	; USART Transmitt Complete
.equ	RXC	= 7	; USART Receive Complete

; UCSRB - USART Control and Status Register B
.equ	UCR	= UCSRB	; For compatibility
.equ	TXB8	= 0	; Transmit Data Bit 8
.equ	RXB8	= 1	; Receive Data Bit 8
.equ	UCSZ2	= 2	; Character Size
.equ	CHR9	= UCSZ2	; For compatibility
.equ	TXEN	= 3	; Transmitter Enable
.equ	RXEN	= 4	; Receiver Enable
.equ	UDRIE	= 5	; USART Data register Empty Interrupt Enable
.equ	TXCIE	= 6	; TX Complete Interrupt Enable
.equ	RXCIE	= 7	; RX Complete Interrupt Enable

; UCSRC - USART Control and Status Register C
.equ	UCPOL	= 0	; Clock Polarity
.equ	UCSZ0	= 1	; Character Size
.equ	UCSZ1	= 2	; Character Size
.equ	USBS	= 3	; Stop Bit Select
.equ	UPM0	= 4	; Parity Mode Bit 0
.equ	UPM1	= 5	; Parity Mode Bit 1
.equ	UMSEL	= 6	; USART Mode Select
.equ	URSEL	= 7	; Register Select

.equ	UBRRHI	= UBRRH	; For compatibility

; ***** TWI **************************
; TWBR - TWI Bit Rate register
.equ	I2BR	= TWBR	; For compatibility
.equ	TWBR0	= 0	; 
.equ	TWBR1	= 1	; 
.equ	TWBR2	= 2	; 
.equ	TWBR3	= 3	; 
.equ	TWBR4	= 4	; 
.equ	TWBR5	= 5	; 
.equ	TWBR6	= 6	; 
.equ	TWBR7	= 7	; 

; TWCR - TWI Control Register
.equ	I2CR	= TWCR	; For compatibility
.equ	TWIE	= 0	; TWI Interrupt Enable
.equ	I2IE	= TWIE	; For compatibility
.equ	TWEN	= 2	; TWI Enable Bit
.equ	I2EN	= TWEN	; For compatibility
.equ	ENI2C	= TWEN	; For compatibility
.equ	TWWC	= 3	; TWI Write Collition Flag
.equ	I2WC	= TWWC	; For compatibility
.equ	TWSTO	= 4	; TWI Stop Condition Bit
.equ	I2STO	= TWSTO	; For compatibility
.equ	TWSTA	= 5	; TWI Start Condition Bit
.equ	I2STA	= TWSTA	; For compatibility
.equ	TWEA	= 6	; TWI Enable Acknowledge Bit
.equ	I2EA	= TWEA	; For compatibility
.equ	TWINT	= 7	; TWI Interrupt Flag
.equ	I2INT	= TWINT	; For compatibility

; TWSR - TWI Status Register
.equ	I2SR	= TWSR	; For compatibility
.equ	TWPS0	= 0	; TWI Prescaler
.equ	TWS0	= TWPS0	; For compatibility
.equ	I2GCE	= TWPS0	; For compatibility
.equ	TWPS1	= 1	; TWI Prescaler
.equ	TWS1	= TWPS1	; For compatibility
.equ	TWS3	= 3	; TWI Status
.equ	I2S3	= TWS3	; For compatibility
.equ	TWS4	= 4	; TWI Status
.equ	I2S4	= TWS4	; For compatibility
.equ	TWS5	= 5	; TWI Status
.equ	I2S5	= TWS5	; For compatibility
.equ	TWS6	= 6	; TWI Status
.equ	I2S6	= TWS6	; For compatibility
.equ	TWS7	= 7	; TWI Status
.equ	I2S7	= TWS7	; For compatibility

; TWDR - TWI Data register
.equ	I2DR	= TWDR	; For compatibility
.equ	TWD0	= 0	; TWI Data Register Bit 0
.equ	TWD1	= 1	; TWI Data Register Bit 1
.equ	TWD2	= 2	; TWI Data Register Bit 2
.equ	TWD3	= 3	; TWI Data Register Bit 3
.equ	TWD4	= 4	; TWI Data Register Bit 4
.equ	TWD5	= 5	; TWI Data Register Bit 5
.equ	TWD6	= 6	; TWI Data Register Bit 6
.equ	TWD7	= 7	; TWI Data Register Bit 7

; TWAR - TWI (Slave) Address register
.equ	I2AR	= TWAR	; For compatibility
.equ	TWGCE	= 0	; TWI General Call Recognition Enable Bit
.equ	TWA0	= 1	; TWI (Slave) Address register Bit 0
.equ	TWA1	= 2	; TWI (Slave) Address register Bit 1
.equ	TWA2	= 3	; TWI (Slave) Address register Bit 2
.equ	TWA3	= 4	; TWI (Slave) Address register Bit 3
.equ	TWA4	= 5	; TWI (Slave) Address register Bit 4
.equ	TWA5	= 6	; TWI (Slave) Address register Bit 5
.equ	TWA6	= 7	; TWI (Slave) Address register Bit 6


; ***** WATCHDOG *********************
; WDTCR - Watchdog Timer Control Register
.equ	WDTCSR	= WDTCR	; For compatibility
.equ	WDP0	= 0	; Watch Dog Timer Prescaler bit 0
.equ	WDP1	= 1	; Watch Dog Timer Prescaler bit 1
.equ	WDP2	= 2	; Watch Dog Timer Prescaler bit 2
.equ	WDE	= 3	; Watch Dog Enable
.equ	WDCE	= 4	; Watchdog Change Enable
.equ	WDTOE	= WDCE	; For compatibility


; ***** PORTB ************************
; PORTB - Port B Data Register
.equ	PORTB0	= 0	; Port B Data Register bit 0
.equ	PB0	= 0	; For compatibility
.equ	PORTB1	= 1	; Port B Data Register bit 1
.equ	PB1	= 1	; For compatibility
.equ	PORTB2	= 2	; Port B Data Register bit 2
.equ	PB2	= 2	; For compatibility
.equ	PORTB3	= 3	; Port B Data Register bit 3
.equ	PB3	= 3	; For compatibility
.equ	PORTB4	= 4	; Port B Data Register bit 4
.equ	PB4	= 4	; For compatibility
.equ	PORTB5	= 5	; Port B Data Register bit 5
.equ	PB5	= 5	; For compatibility
.equ	PORTB6	= 6	; Port B Data Register bit 6
.equ	PB6	= 6	; For compatibility
.equ	PORTB7	= 7	; Port B Data Register bit 7
.equ	PB7	= 7	; For compatibility

; DDRB - Port B Data Direction Register
.equ	DDB0	= 0	; Port B Data Direction Register bit 0
.equ	DDB1	= 1	; Port B Data Direction Register bit 1
.equ	DDB2	= 2	; Port B Data Direction Register bit 2
.equ	DDB3	= 3	; Port B Data Direction Register bit 3
.equ	DDB4	= 4	; Port B Data Direction Register bit 4
.equ	DDB5	= 5	; Port B Data Direction Register bit 5
.equ	DDB6	= 6	; Port B Data Direction Register bit 6
.equ	DDB7	= 7	; Port B Data Direction Register bit 7

; PINB - Port B Input Pins
.equ	PINB0	= 0	; Port B Input Pins bit 0
.equ	PINB1	= 1	; Port B Input Pins bit 1
.equ	PINB2	= 2	; Port B Input Pins bit 2
.equ	PINB3	= 3	; Port B Input Pins bit 3
.equ	PINB4	= 4	; Port B Input Pins bit 4
.equ	PINB5	= 5	; Port B Input Pins bit 5
.equ	PINB6	= 6	; Port B Input Pins bit 6
.equ	PINB7	= 7	; Port B Input Pins bit 7


; ***** PORTC ************************
; PORTC - Port C Data Register
.equ	PORTC0	= 0	; Port C Data Register bit 0
.equ	PC0	= 0	; For compatibility
.equ	PORTC1	= 1	; Port C Data Register bit 1
.equ	PC1	= 1	; For compatibility
.equ	PORTC2	= 2	; Port C Data Register bit 2
.equ	PC2	= 2	; For compatibility
.equ	PORTC3	= 3	; Port C Data Register bit 3
.equ	PC3	= 3	; For compatibility
.equ	PORTC4	= 4	; Port C Data Register bit 4
.equ	PC4	= 4	; For compatibility
.equ	PORTC5	= 5	; Port C Data Register bit 5
.equ	PC5	= 5	; For compatibility
.equ	PORTC6	= 6	; Port C Data Register bit 6
.equ	PC6	= 6	; For compatibility

; DDRC - Port C Data Direction Register
.equ	DDC0	= 0	; Port C Data Direction Register bit 0
.equ	DDC1	= 1	; Port C Data Direction Register bit 1
.equ	DDC2	= 2	; Port C Data Direction Register bit 2
.equ	DDC3	= 3	; Port C Data Direction Register bit 3
.equ	DDC4	= 4	; Port C Data Direction Register bit 4
.equ	DDC5	= 5	; Port C Data Direction Register bit 5
.equ	DDC6	= 6	; Port C Data Direction Register bit 6

; PINC - Port C Input Pins
.equ	PINC0	= 0	; Port C Input Pins bit 0
.equ	PINC1	= 1	; Port C Input Pins bit 1
.equ	PINC2	= 2	; Port C Input Pins bit 2
.equ	PINC3	= 3	; Port C Input Pins bit 3
.equ	PINC4	= 4	; Port C Input Pins bit 4
.equ	PINC5	= 5	; Port C Input Pins bit 5
.equ	PINC6	= 6	; Port C Input Pins bit 6


; ***** PORTD ************************
; PORTD - Port D Data Register
.equ	PORTD0	= 0	; Port D Data Register bit 0
.equ	PD0	= 0	; For compatibility
.equ	PORTD1	= 1	; Port D Data Register bit 1
.equ	PD1	= 1	; For compatibility
.equ	PORTD2	= 2	; Port D Data Register bit 2
.equ	PD2	= 2	; For compatibility
.equ	PORTD3	= 3	; Port D Data Register bit 3
.equ	PD3	= 3	; For compatibility
.equ	PORTD4	= 4	; Port D Data Register bit 4
.equ	PD4	= 4	; For compatibility
.equ	PORTD5	= 5	; Port D Data Register bit 5
.equ	PD5	= 5	; For compatibility
.equ	PORTD6	= 6	; Port D Data Register bit 6
.equ	PD6	= 6	; For compatibility
.equ	PORTD7	= 7	; Port D Data Register bit 7
.equ	PD7	= 7	; For compatibility

; DDRD - Port D Data Direction Register
.equ	DDD0	= 0	; Port D Data Direction Register bit 0
.equ	DDD1	= 1	; Port D Data Direction Register bit 1
.equ	DDD2	= 2	; Port D Data Direction Register bit 2
.equ	DDD3	= 3	; Port D Data Direction Register bit 3
.equ	DDD4	= 4	; Port D Data Direction Register bit 4
.equ	DDD5	= 5	; Port D Data Direction Register bit 5
.equ	DDD6	= 6	; Port D Data Direction Register bit 6
.equ	DDD7	= 7	; Port D Data Direction Register bit 7

; PIND - Port D Input Pins
.equ	PIND0	= 0	; Port D Input Pins bit 0
.equ	PIND1	= 1	; Port D Input Pins bit 1
.equ	PIND2	= 2	; Port D Input Pins bit 2
.equ	PIND3	= 3	; Port D Input Pins bit 3
.equ	PIND4	= 4	; Port D Input Pins bit 4
.equ	PIND5	= 5	; Port D Input Pins bit 5
.equ	PIND6	= 6	; Port D Input Pins bit 6
.equ	PIND7	= 7	; Port D Input Pins bit 7


; ***** EEPROM ***********************
; EEDR - EEPROM Data Register
.equ	EEDR0	= 0	; EEPROM Data Register bit 0
.equ	EEDR1	= 1	; EEPROM Data Register bit 1
.equ	EEDR2	= 2	; EEPROM Data Register bit 2
.equ	EEDR3	= 3	; EEPROM Data Register bit 3
.equ	EEDR4	= 4	; EEPROM Data Register bit 4
.equ	EEDR5	= 5	; EEPROM Data Register bit 5
.equ	EEDR6	= 6	; EEPROM Data Register bit 6
.equ	EEDR7	= 7	; EEPROM Data Register bit 7

; EECR - EEPROM Control Register
.equ	EERE	= 0	; EEPROM Read Enable
.equ	EEWE	= 1	; EEPROM Write Enable
.equ	EEMWE	= 2	; EEPROM Master Write Enable
.equ	EEWEE	= EEMWE	; For compatibility
.equ	EERIE	= 3	; EEPROM Ready Interrupt Enable


; ***** CPU **************************
; SREG - Status Register
.equ	SREG_C	= 0	; Carry Flag
.equ	SREG_Z	= 1	; Zero Flag
.equ	SREG_N	= 2	; Negative Flag
.equ	SREG_V	= 3	; Two's Complement Overflow Flag
.equ	SREG_S	= 4	; Sign Bit
.equ	SREG_H	= 5	; Half Carry Flag
.equ	SREG_T	= 6	; Bit Copy Storage
.equ	SREG_I	= 7	; Global Interrupt Enable

; MCUCR - MCU Control Register
;.equ	ISC00	= 0	; Interrupt Sense Control 0 Bit 0
;.equ	ISC01	= 1	; Interrupt Sense Control 0 Bit 1
;.equ	ISC10	= 2	; Interrupt Sense Control 1 Bit 0
;.equ	ISC11	= 3	; Interrupt Sense Control 1 Bit 1
.equ	SM0	= 4	; Sleep Mode Select
.equ	SM1	= 5	; Sleep Mode Select
.equ	SM2	= 6	; Sleep Mode Select
.equ	SE	= 7	; Sleep Enable

; MCUCSR - MCU Control And Status Register
.equ	MCUSR	= MCUCSR	; For compatibility
.equ	PORF	= 0	; Power-on reset flag
.equ	EXTRF	= 1	; External Reset Flag
.equ	BORF	= 2	; Brown-out Reset Flag
.equ	WDRF	= 3	; Watchdog Reset Flag

; OSCCAL - Oscillator Calibration Value
.equ	CAL0	= 0	; Oscillator Calibration Value Bit0
.equ	CAL1	= 1	; Oscillator Calibration Value Bit1
.equ	CAL2	= 2	; Oscillator Calibration Value Bit2
.equ	CAL3	= 3	; Oscillator Calibration Value Bit3
.equ	CAL4	= 4	; Oscillator Calibration Value Bit4
.equ	CAL5	= 5	; Oscillator Calibration Value Bit5
.equ	CAL6	= 6	; Oscillator Calibration Value Bit6
.equ	CAL7	= 7	; Oscillator Calibration Value Bit7

; SPMCR - Store Program Memory Control Register
.equ	SPMEN	= 0	; Store Program Memory Enable
.equ	PGERS	= 1	; Page Erase
.equ	PGWRT	= 2	; Page Write
.equ	BLBSET	= 3	; Boot Lock Bit Set
.equ	RWWSRE	= 4	; Read-While-Write Section Read Enable
.equ	RWWSB	= 6	; Read-While-Write Section Busy
.equ	SPMIE	= 7	; SPM Interrupt Enable

; SFIOR - Special Function IO Register
.equ	PSR10	= 0	; Prescaler Reset Timer/Counter1 and Timer/Counter0
.equ	PUD	= 2	; Pull-up Disable
.equ	ADHSM	= 4	; ADC High Speed Mode


; ***** AD_CONVERTER *****************
; ADMUX - The ADC multiplexer Selection Register
.equ	MUX0	= 0	; Analog Channel and Gain Selection Bits
.equ	MUX1	= 1	; Analog Channel and Gain Selection Bits
.equ	MUX2	= 2	; Analog Channel and Gain Selection Bits
.equ	MUX3	= 3	; Analog Channel and Gain Selection Bits
.equ	ADLAR	= 5	; Left Adjust Result
.equ	REFS0	= 6	; Reference Selection Bit 0
.equ	REFS1	= 7	; Reference Selection Bit 1

; ADCSRA - The ADC Control and Status register
.equ	ADCSR	= ADCSRA	; For compatibility
.equ	ADPS0	= 0	; ADC  Prescaler Select Bits
.equ	ADPS1	= 1	; ADC  Prescaler Select Bits
.equ	ADPS2	= 2	; ADC  Prescaler Select Bits
.equ	ADIE	= 3	; ADC Interrupt Enable
.equ	ADIF	= 4	; ADC Interrupt Flag
.equ	ADFR	= 5	; ADC  Free Running Select
.equ	ADSC	= 6	; ADC Start Conversion
.equ	ADEN	= 7	; ADC Enable



; ***** LOCKSBITS ********************************************************
.equ	LB1	= 0	; Lock bit
.equ	LB2	= 1	; Lock bit
.equ	BLB01	= 2	; Boot Lock bit
.equ	BLB02	= 3	; Boot Lock bit
.equ	BLB11	= 4	; Boot lock bit
.equ	BLB12	= 5	; Boot lock bit


; ***** FUSES ************************************************************
; LOW fuse bits
.equ	CKSEL0	= 0	; Select Clock Source
.equ	CKSEL1	= 1	; Select Clock Source
.equ	CKSEL2	= 2	; Select Clock Source
.equ	CKSEL3	= 3	; Select Clock Source
.equ	SUT0	= 4	; Select start-up time
.equ	SUT1	= 5	; Select start-up time
.equ	BODEN	= 6	; Brown out detector enable
.equ	BODLEVEL	= 7	; Brown out detector trigger level

; HIGH fuse bits
.equ	BOOTRST	= 0	; Select Reset Vector
.equ	BOOTSZ0	= 1	; Select Boot Size
.equ	BOOTSZ1	= 2	; Select Boot Size
.equ	EESAVE	= 3	; EEPROM memory is preserved through chip erase
.equ	CKOPT	= 4	; Oscillator Options
.equ	SPIEN	= 5	; Enable Serial programming and Data Downloading
.equ	WTDON	= 6	; Enable watchdog
.equ	RSTDISBL	= 7	; Disable reset



; ***** CPU REGISTER DEFINITIONS *****************************************
.def	XH	= r27
.def	XL	= r26
.def	YH	= r29
.def	YL	= r28
.def	ZH	= r31
.def	ZL	= r30



; ***** DATA MEMORY DECLARATIONS *****************************************
.equ	FLASHEND	= 0x0fff	; Note: Word address
.equ	IOEND	= 0x003f
.equ	SRAM_START	= 0x0060
.equ	SRAM_SIZE	= 1024
.equ	RAMEND	= 0x045f
.equ	XRAMEND	= 0x0000
.equ	E2END	= 0x01ff
.equ	EEPROMEND	= 0x01ff
.equ	EEADRBITS	= 9
#pragma AVRPART MEMORY PROG_FLASH 8192
#pragma AVRPART MEMORY EEPROM 512
#pragma AVRPART MEMORY INT_SRAM SIZE 1024
#pragma AVRPART MEMORY INT_SRAM START_ADDR 0x60



; ***** BOOTLOADER DECLARATIONS ******************************************
.equ	NRWW_START_ADDR	= 0xc00
.equ	NRWW_STOP_ADDR	= 0xfff
.equ	RWW_START_ADDR	= 0x0
.equ	RWW_STOP_ADDR	= 0xbff
.equ	PAGESIZE	= 32
.equ	FIRSTBOOTSTART	= 0xf80
.equ	SECONDBOOTSTART	= 0xf00
.equ	THIRDBOOTSTART	= 0xe00
.equ	FOURTHBOOTSTART	= 0xc00
.equ	SMALLBOOTSTART	= FIRSTBOOTSTART
.equ	LARGEBOOTSTART	= FOURTHBOOTSTART



; ***** INTERRUPT VECTORS ************************************************
.equ	INT0addr	= 0x0001	; External Interrupt Request 0
.equ	INT1addr	= 0x0002	; External Interrupt Request 1
.equ	OC2addr	= 0x0003	; Timer/Counter2 Compare Match
.equ	OVF2addr	= 0x0004	; Timer/Counter2 Overflow
.equ	ICP1addr	= 0x0005	; Timer/Counter1 Capture Event
.equ	OC1Aaddr	= 0x0006	; Timer/Counter1 Compare Match A
.equ	OC1Baddr	= 0x0007	; Timer/Counter1 Compare Match B
.equ	OVF1addr	= 0x0008	; Timer/Counter1 Overflow
.equ	OVF0addr	= 0x0009	; Timer/Counter0 Overflow
.equ	SPIaddr	= 0x000a	; Serial Transfer Complete
.equ	URXCaddr	= 0x000b	; USART, Rx Complete
.equ	UDREaddr	= 0x000c	; USART Data Register Empty
.equ	UTXCaddr	= 0x000d	; USART, Tx Complete
.equ	ADCCaddr	= 0x000e	; ADC Conversion Complete
.equ	ERDYaddr	= 0x000f	; EEPROM Ready
.equ	ACIaddr	= 0x0010	; Analog Comparator
.equ	TWIaddr	= 0x0011	; 2-wire Serial Interface
.equ	SPMRaddr	= 0x0012	; Store Program Memory Ready

.equ	INT_VECTORS_SIZE	= 19	; size in words

#pragma AVRPART CORE INSTRUCTIONS_NOT_SUPPORTED break

#endif  /* _M8ADEF_INC_ */

; ***** END OF FILE ******************************************************
/*
 * hr_avr.asm
 *  Created: 30.06.2018 10:12:37
 *   Author: Lihouzov Evgeny
 */
 
//=========================    ======================================
rjmp   load_cfg;
//-- Interrupt --
; ***** INTERRUPT VECTORS ************************************************
reti                     ;0x0001 External Interrupt Request 0  (iINT0addr)
reti                     ;0x0002 External Interrupt Request 1  (iINT1addr)
reti                     ;0x0003 Timer/Counter2 Compare Match  (iOC2addr)
reti                     ;0x0004 Timer/Counter2 Overflow  (iOVF2addr)
reti                     ;0x0005 Timer/Counter1 Capture Event  (iICP1addr)
reti                     ;0x0006 Timer/Counter1 Compare Match A  (iOC1Aaddr)
reti                     ;0x0007 Timer/Counter1 Compare Match B  (iOC1Baddr)
reti                     ;0x0008 Timer/Counter1 Overflow  (iOVF1addr)
rjmp iOVF0addr           ;0x0009 Timer/Counter0 Overflow
reti                     ;0x000a Serial Transfer Complete  (iSPIaddr)
reti                     ;0x000b USART, Rx Complete  (iURXCaddr)
reti                     ;0x000c USART Data Register Empty  (iUDREaddr)
reti                     ;0x000d USART, Tx Complete  (iUTXCaddr)
reti                     ;0x000e ADC Conversion Complete  (iADCCaddr)
reti                     ;0x000f EEPROM Ready  (iERDYaddr)
reti                     ;0x0010 Analog Comparator  (iACIaddr)
reti                     ;0x0011 2-wire Serial Interface  (iTWIaddr)
reti                     ;0x0012 Store Program Memory Ready  (iSPMRaddr)
;****	INT_VECTORS_SIZE	= 19	; size in word     ****
;****   Vector count = 19 ****
;****   Vector size  = 19 ****
.org INT_VECTORS_SIZE

// 
  .def  Addr_Data       = r0   //  (   )
  .def  Kern_A          = r1   //     
  .def  Zero            = r2   //    !!!
  .def  One             = r3   //    !!!
  .def  Uzel_Count      = r4   //    
  .def  FBD_size        = r5   //  FBD 
  .def  FBD_mem         = r6   //   

  .def  Uz1L            = r7   // 
  .def  Uz1H            = r8   // 
  .def  Uz2L            = r9   // 
  .def  Uz2H            = r10  // 
  .def  Uz3L            = r11  // 
  .def  Uz3H            = r12  // 
  .def  A               = r16  //   
  .def  B               = r17  //   
  .def  C               = r18   //   
  .def  D               = r19  //   
  .def  E               = r20  //   
  .def  F               = r21  //   
  .def  G               = r22  //   
  .def  H               = r23  //   

  .def  iA              = r24  //    
  .def  iB              = r25  //    

//  .def	Adr_RAM_H	    = r27  //        XH
//  .def	Adr_RAM_L	    = r26  //        XL
//  .def	Adr_EEPROM_H	= r29  //      YH
//  .def	Adr_EEPROM_L	= r28  //      YL
//  .def	Adr_flash_H	    = r31                                        ZH
//  .def	Adr_flash_L	    = r30                                        ZL


.MACRO    UOUT               //UOUT  "MEMORY MAPPED"   out 
.if	@0 < 0x40
      	out	@0,@1         
.else
      	sts	@0,@1
.endif
.ENDMACRO

.MACRO    UIN               //UIN  "MEMORY MAPPED"   in 
.if	@1 < 0x40
      	in	@0,@1         
.else
      	lds	@0,@1
.endif
.ENDMACRO

.MACRO    USBI               //USBI  "MEMORY MAPPED"   sbi 
.if	@0 < 0x40
      	sbi	@0,@1         
.else
      	lds	H,@0
        ori     H, 1 << @1
        sts     @0, H 
.endif
.ENDMACRO

.MACRO    UCBI               //UCBI  "MEMORY MAPPED"   cbi 
.if	@0 < 0x40
      	cbi	@0,@1         
.else
      	lds	H,@0
        cbr     H,@1
        sts     @0, H 
.endif
.ENDMACRO

.MACRO    USBIC               //USBIC  "MEMORY MAPPED"   sbic 
.if	@0 < 0x40
      	sbic 	@0,@1         
.else
      	lds	H,@0
        sbrc    H,@1
.endif
.ENDMACRO

.SET FBD_DATA_RAM = SRAM_START  //   FBD    
//-- Include --
//************************************************ FBD ****************************************************
#ifndef _FBD0_
#define _FBD0_ FBD0
#message define FBD0 (LCD_HD44780_2x16)__FILE__
.SET LCD_HD44780_STR_LENGTH= 16
.SET LCD_HD44780_STR_COUNT = 2
.SET LCD_HD44780_DATA_SIZE = LCD_HD44780_STR_LENGTH*LCD_HD44780_STR_COUNT
.SET LCD_HD44780_DATA_RAM = FBD_DATA_RAM                          //   LCD
.SET FBD_DATA_RAM = LCD_HD44780_DATA_RAM + LCD_HD44780_DATA_SIZE  //   LCD
//16  - 
//16  - 

//  FDB  6+32+6=44 
//6  - 
//16 -  
//16 -  
//1  -  DB4
//1  -  DB5
//1  -  DB6
//1  -  DB7
//1  -  RS
//1  -  E
//   
//     1  
//     1   

FBD0_init:
 ADIW  YL, 6         //   
 ldi   A,  LCD_HD44780_DATA_SIZE     
 ldi   B,  0
Loop_LCD_Copy:                
 sub A, One                       
 brcs End_LCD_copy                 
 rcall Read_cfg                        
 mov   ZL, B
 rcall LCD_out_char     
 inc   B
 rjmp  Loop_LCD_copy                 
End_LCD_copy:

 ADIW  YL, 6    
 ldi A, 4             
 st  X+, A    //
 st  X+, Zero //           
ret;



FBD0_run:
 ld G, X+                 //
 ld H, X+                 // 

FBD0_next_run:
 mov A, G
 //inc A
 
 mov  C, A                // 
 inc  C
 eor  C, G                // 
 swap C                   // 
 andi C,0b00000001        // 
   

 sbrc G, 7                // 
 rjmp FBD0_next          // 

 lsl   A                  //  
 swap  A                  //  
 andi  A, 0b00001111      //  
 cpi   A, 6               //  
 brcc  FBD0_end_init     //  
 
 mov  ZH, YH              //   
 mov  ZL, YL              //   
 add  ZL, A               //   
 adc  ZH, Zero            //   
 
 lpm  B, Z                //   
 rjmp FBD0_set_pin

FBD0_end_init:
 clr  H                   // 
 ldi  G, 0b10000000       // 
 rjmp FBD0_next_run      // 

FBD0_next:               // 
 sbrs G, 3                // /
 rjmp FBD0_out_addres    // /

 ldi   ZL, Low(LCD_HD44780_DATA_RAM)   
 ldi   ZH, High(LCD_HD44780_DATA_RAM)      
 add  ZL, H               //   LCD
 adc  ZH, Zero            //   LCD
 ld   B,  Z               //   LCD
 rjmp FBD0_set_pin

FBD0_out_addres:
 mov  B, H
 ori  B, 0b10000000       // 
 cpi  H, LCD_HD44780_STR_LENGTH
 brcs FBD0_set_pin
 
// ldi   ZL, Low(LCD_HD44780_DATA_RAM)   
// ldi   ZH, High(LCD_HD44780_DATA_RAM)      
// ld    F,  Z
 ldi  F, 48
 add  B, F

FBD0_set_pin:
 ADIW  YL, 6+LCD_HD44780_DATA_SIZE //  

//=============    =========
 sbrc G, 2                //  
 swap B                   //  

 clr  Uz1H                // 
 mov  Uz1L, One           //   4 
 sbrs B, 4                //   4 
 clr  Uz1L                //   4 
 rcall Read_cfg_Save_Uz1  // 
 mov  Uz1L, One           //   5 
 sbrs B, 5                //   5 
 clr  Uz1L                //   5 
 rcall Read_cfg_Save_Uz1  // 
 mov  Uz1L, One           //   6 
 sbrs B, 6                //   6 
 clr  Uz1L                //   6 
 rcall Read_cfg_Save_Uz1  // 
 mov  Uz1L, One           //   7 
 sbrs B, 7                //   7 
 clr  Uz1L                //   7 
 rcall Read_cfg_Save_Uz1  // 

 mov  Uz1L, One           // RS (0-  1-)
 sbrs G, 7                // 
 clr  Uz1L                // 
 sbrs G, 3                // /
 clr  Uz1L                // /
 rcall Read_cfg_Save_Uz1  //  RS

 inc  G                   // 
 andi G, 0b10111111       // 

 mov  Uz1L, One           // E (1-0  )
 sbrs G, 0                // E 
 clr  Uz1L                // E 
 sbrs G, 1                // E 
 clr  Uz1L                // E 
 rcall Read_cfg_Save_Uz1  //  E
//================   ===========
  add H, C                     // 
  cpi H, LCD_HD44780_DATA_SIZE // 
  brcs FBD0_save              // 
  clr H                        //  
  ldi G, 0b10000000  

// ldi   ZL, Low(LCD_HD44780_DATA_RAM)   
// ldi   ZH, High(LCD_HD44780_DATA_RAM)      
// ld    F,  Z
// inc   F
// andi  F, 0b00111111
// st    Z, F  

FBD0_save:
//=============   =========
  sbiw  XL, 2
  st X+, G
  st X+, H
ret;



LCD_out_char:       //ZL-   Addr_Data-  
  cpi   ZL,  LCD_HD44780_DATA_SIZE
  brcc  LCD_out_char_end
  ldi   ZH, Low(LCD_HD44780_DATA_RAM)
  add   ZL, ZH
  ldi   ZH, High(LCD_HD44780_DATA_RAM)
  adc   ZH, Zero
  st    Z,  Addr_Data
LCD_out_char_end:
ret

#else
#error redeclared FBD0 __FILE__
#endif
//********************************************************************************************************
#ifndef _FBD1_
#define _FBD1_ FBD1
#message define FBD1 __FILE__

FBD1_init:
 rcall Read_cfg_Set_Bit_Reg_A                     ;    

 in    D, DDRB                                    ; 
 or    D, A                                       ; 
 sbrs  Addr_Data, 3                               ;
 eor   D, A                                       ; 
 out   DDRB, D                                    ;

 in    D, PORTB                                   ;  
 or    D, A                                       ; 
 sbrs  Addr_Data, 4                               ;
 eor   D, A                                       ; 
 out   PORTB, D                                   ;

 rcall Read_cfg                                   ;  
 ret;

FBD1_run:
 rcall Read_cfg_Set_Bit_Reg_A                     ;    

 sbrc  Addr_Data, 3                               ;  
 rjmp  FBD1_Out_Pin                               ;

 clr   Uz1L;
 clr   Uz1H;
 in    D, PINB                                    ;  
 and   A, D                                       ; 
 cpse  A, Zero
 inc   Uz1L
 rcall Read_cfg_Save_Uz1                          ;
 ret;

FBD1_Out_Pin: 
 rcall Read_cfg_Load_Uz1                          ; 
 in    D, PORTB                                   ;  
 or    D, A                                       ; 
 sbrs  Uz1L, 0                                    ;
 eor   D, A                                       ; 
 out   PORTB, D                                   ;
 ret;

#else 
 #error redeclared FBD1 __FILE__
#endif
//********************************************************************************************************
#ifndef _FBD2_
#define _FBD2_ FBD2
#message define FBD2 (ADC_ATmega8A_config)__FILE__

.SET ADC_DATA_RAM_ADR = FBD_DATA_RAM  //   ADC
.SET FBD_DATA_RAM = FBD_DATA_RAM + 1  // 1     ADC
// Stat ADC
//  7   ADC_run
//  0-1 MUX
//  FDB  2 
//1 - ADCSRA
//1 - ADMUX
FBD2_init:
rcall Read_cfg                                                                   ;ADCSRA
out ADCSRA, Addr_Data
rcall Read_cfg                                                                   ;ADMUX
out ADMUX,  Addr_Data
ldi   ZL, Low(ADC_DATA_RAM_ADR)           //    ADC_DATA_RAM_ADR
ldi   ZH, High(ADC_DATA_RAM_ADR)          //    ADC_DATA_RAM_ADR
st  Z, Zero                               //   
ret;

FBD2_run:
ADIW  YL, 2                               // 2  
ldi   ZL, Low(ADC_DATA_RAM_ADR)           //    ADC_DATA_RAM_ADR
ldi   ZH, High(ADC_DATA_RAM_ADR)          //    ADC_DATA_RAM_ADR
ld    A, Z                                //   ADC
mov   B, A                                //   ADC
inc   B                                   //MUX   
andi  B, 0b00000111                       // MUX 
andi  A, 0b11111000                       //
add   A, B                                //
sbrc  A, 7                                //   ADC
rjmp  FBD2_end                           //   
in    C, ADMUX                            //  
andi  C, 0b11111000                       // MUX
add   C, B                                //
out   ADMUX, C                            //  
st    Z, A                                //  
FBD2_end:
ret;

#else
#error redeclared FBD2 __FILE__
#endif
//********************************************************************************************************
#ifndef _FBD3_
#define _FBD3_ FBD3
#message define FBD3 (Const_real) __FILE__

//  FDB  5 
//4 -   
//1 -   
//  4  (  )

FBD3_init:     
 rcall Read_cfg                                   ;    RAM
 st    X+, Addr_Data                              ;    RAM
 rcall Read_cfg                                   ;    RAM
 st    X+, Addr_Data                              ;    RAM
 rcall Read_cfg                                   ;    RAM
 st    X+, Addr_Data                              ;    RAM
 rcall Read_cfg                                   ;    RAM
 st    X+, Addr_Data                              ;    RAM
 ADIW  YL, 1                                      ;  
 ret                                              ;  


FBD3_run:
//========       ========= 
 mov   Uz1L, XL                             ;   
 mov   Uz1H, XH                             ;   
 ADIW  YL, 4                                ;  
 ADIW  XL, 4                                ;  
//==================   FBD  ==================   
 rcall Read_cfg_Save_Uz1                    ;    
 ret 
                                       ;   
#else 
 #error redeclared FBD3 __FILE__
#endif
//********************************************************************************************************
#ifndef _FBD4_
#define _FBD4_ FBD4
#message define FBD4 (ADC_in)__FILE__

//  FDB  2 
//1 -   
//1 - 
FBD4_data:
  .db 0b11111110, 0b11111101, 0b11111011, 0b11110111, 0b11101111, 0b11011111
FBD4_init:
 ADIW  YL, 1                              // 1  ""
 rcall Read_cfg                           // 
 ldi   A, 0b00000111                      // 
 and   A, Addr_Data                       //  
 ldi   ZL, Low(FBD4_data*2)              //  
 ldi   ZH, High(FBD4_data*2)             //  
 add   ZL, A                              //
 adc   ZH, Zero                           //
 lpm                                      //   
 in    B, DDRC                            //  
 and   B, Addr_Data                       // 
 out   DDRC, B                            //
 ret;



FBD4_run:
 rcall Read_cfg                           //  
 mov   B, Addr_Data                       //   FBD  
 rcall Read_cfg                           //  
 mov   C, Addr_Data                       // 
 ldi   ZL, Low(ADC_DATA_RAM_ADR)          //    ADC_DATA_RAM_ADR
 ldi   ZH, High(ADC_DATA_RAM_ADR)         //    ADC_DATA_RAM_ADR
 ld    A,  Z                              //   ADC

 mov   D, C                               //   MUX
 eor   D, A                               //   MUX
 andi  D, 0b00000111                      //   MUX
 brne  FBD4_end                          // MUX  


 sbrs  A, 7                               //   ADC
 rjmp  FBD4_start_ADC                    //    
 sbic  ADCSRA, ADSC                       //   
 rjmp  FBD4_end                          //  
 cbr   A, 0b10000000                      //  ( )
 st    Z, A                               //  
 in    Uz1L, ADCL                         // 
 in    Uz1H, ADCH                         // 
 mov   Addr_Data, B                       //     A
 rcall Save_Uz1                           //     A
 ret

FBD4_start_ADC:
 sbi   ADCSRA, ADSC                       // 
 sbr   A, 0b10000000                      //  ( )
 st    Z, A                               //  
FBD4_end: 
 ret;



#else 
 #error redeclared FBD4  __FILE__
#endif
//********************************************************************************************************
#ifndef _FBD5_
#define _FBD5_ FBD5
#message define FBD5 (integer less)__FILE__

//  FDB  3 
//1 -  1
//1 -  2
//1 - 
//   

FBD5_run:
//========       ========= 
 rcall Read_cfg_Load_Uz1                                   ; 1 
 rcall Read_cfg_Load_Uz2                                   ; 2 
//=============   FBD  ==================
 clr  Uz3H                            ; 
 clr  Uz3L                            ; 
 cp   Uz1L, Uz2L                      ;
 cpc  Uz1H, Uz2H                      ;
 brcc FBD5_zero
 inc  Uz3L                            ;Uz1>Uz2
FBD5_zero:
//=============    ==================
 rcall Read_cfg_Save_Uz3                                   ; 
 ret;

#else 
 #error redeclared FBD5 __FILE__
#endif
//********************************************************************************************************
#ifndef _FBD6_
#define _FBD6_ FBD6
#message define FBD6 (Int16ToSingl)__FILE__

//  FDB  3 
//1 - 
//1 - 
//  4 

//    
#define _real_Int16ToReal_fun_

FBD6_run:
//=====       ===== 
 rcall Read_Cfg_Load_Uz1    //  Int16
//=============   FBD  =============== 
 rcall real_Int16ToReal     //
//=============    ==================    
  mov Uz1L, XL              // 
  mov Uz1H, XH              // 
  rcall Read_cfg_Save_Uz1   // 
  st    X+, D               // 
  st    X+, C               // 
  st    X+, B               // 
  st    X+, A               // 
 ret

#else 
 #error redeclared FBD6 __FILE__
#endif
//********************************************************************************************************
#ifndef _FBD7_
#define _FBD7_ FBD7
#message define FBD7 (Const) __FILE__

//  FDB  5 
//2 -   
//1 -   

FBD7_run:
//========       ========= 
// rcall Read_cfg                                   ;  
// mov   A, Addr_Data                               ;  
 rcall Read_cfg                                     ;  
 mov   Uz1L, Addr_Data                            ;   Lw
 rcall Read_cfg                                     ;  
 mov   Uz1H, Addr_Data                            ;   Hg
//==================   FBD  ==================
// mov   Addr_Data, A   
 rcall Read_cfg_Save_Uz1                                   ;     A
 ret                                              ;   
#else 
 #error redeclared FBD7 __FILE__
#endif
//********************************************************************************************************
#ifndef _FBD8_
#define _FBD8_ FBD8
#message define FBD8 Countert milliseconds (Timer 0)

#ifdef _Timer0_
#error redeclared Timer0 __FILE__
#endif
#define _Timer0_

.SET TimerCounter0_DATA_SIZE = 6
.SET TimerCounter0_DATA_RAM = FBD_DATA_RAM                               //   TimerCounter0
.SET FBD_DATA_RAM = TimerCounter0_DATA_RAM + TimerCounter0_DATA_SIZE     //   TimerCounter0
// :
//  1  - TCNT0
//  1  - TIMSK

iOVF0addr:  ;  
 LDS iB, TimerCounter0_DATA_RAM+5             ;  
 out TCNT0, iB                                ;  
 in  iB, SREG                                 ;                                     
 LDS iA, TimerCounter0_DATA_RAM               ;   
 add iA, One                                  ;   
 STS TimerCounter0_DATA_RAM, iA               ;   
 out SREG, iB                                 ;    
 reti

FBD8_init:
 rcall Read_cfg                                ; 
 STS   TimerCounter0_DATA_RAM+5, Addr_Data     ;   
 rcall Read_cfg                                ;  


#if defined( _TN13ADEF_INC_)||defined(_TN13DEF_INC_)||defined(_TN25DEF_INC_)||defined(_TN45DEF_INC_)||defined(_TN85DEF_INC_)||defined(_M328PDEF_INC_)
.equ _TCCR0=TCCR0B
#else
.equ _TCCR0=TCCR0
#endif

#if defined( _TN13ADEF_INC_)||defined(_TN13DEF_INC_)||defined(_M328PDEF_INC_)
.equ _TIMSK=TIMSK0
#else
.equ _TIMSK=TIMSK
#endif
 
 out _TCCR0, Addr_Data                          ;                                   
 UIN    A,      _TIMSK                         ;      !!!
 ori   A,     1<<TOIE0                         ;   
 UOUT   _TIMSK,  A                             ;   

 ret;

FBD8_run:
 ADIW  YL, 2                       ;  
 cli                               ; 
 LDS A, TimerCounter0_DATA_RAM     ;   
 STS TimerCounter0_DATA_RAM, Zero  ;   , 
 sei                               ; 
 LDS B, TimerCounter0_DATA_RAM+1   ;  
 add B, A                          ;  
 STS TimerCounter0_DATA_RAM+1, B   ;  
 LDS B, TimerCounter0_DATA_RAM+2   ;  
 adc B, Zero                       ;  
 STS TimerCounter0_DATA_RAM+2, B   ;  
 LDS B, TimerCounter0_DATA_RAM+3   ;  
 adc B, Zero                       ;  
 STS TimerCounter0_DATA_RAM+3, B   ;  
 LDS B, TimerCounter0_DATA_RAM+4   ;  
 adc B, Zero                       ;  
 STS TimerCounter0_DATA_RAM+4, B   ;  
 ret;



Timer_Diff:
  lds  ZL, TimerCounter0_DATA_RAM+1       // Lw
  lds  ZH, TimerCounter0_DATA_RAM+2       // Hg
  sub  ZL, Uz1L                           // 
  sbc  ZH, Uz1H                           // 
//  brcc Timer_Diff_end
//  neg  ZL                                 // 
//  com  ZH                                 // 
//Timer_Diff_end:   
  ret 

#else 
 #error redeclared FBD8 __FILE__
#endif
//********************************************************************************************************
#ifndef _FBD9_
#define _FBD9_ FBD9
#message define FBD9 __FILE__

FBD9_init:
 rcall Read_cfg_Set_Bit_Reg_A                     ;    

 in    D, DDRD                                    ; 
 or    D, A                                       ; 
 sbrs  Addr_Data, 3                               ;
 eor   D, A                                       ; 
 out   DDRD, D                                    ;

 in    D, PORTD                                   ;  
 or    D, A                                       ; 
 sbrs  Addr_Data, 4                               ;
 eor   D, A                                       ; 
 out   PORTD, D                                   ;

 rcall Read_cfg                                   ;  
 ret;

FBD9_run:
 rcall Read_cfg_Set_Bit_Reg_A                     ;    

 sbrc  Addr_Data, 3                               ;  
 rjmp  FBD9_Out_Pin                               ;

 clr   Uz1L;
 clr   Uz1H;
 in    D, PIND                                    ;  
 and   A, D                                       ; 
 cpse  A, Zero
 inc   Uz1L
 rcall Read_cfg_Save_Uz1                          ;
 ret;

FBD9_Out_Pin: 
 rcall Read_cfg_Load_Uz1                          ; 
 in    D, PORTD                                   ;  
 or    D, A                                       ; 
 sbrs  Uz1L, 0                                    ;
 eor   D, A                                       ; 
 out   PORTD, D                                   ;
 ret;

#else 
 #error redeclared FBD9 __FILE__
#endif
//********************************************************************************************************
#ifndef _FBD10_
#define _FBD10_ FBD10
#message define FBD10 (NOT)__FILE__

//  FDB  3 
//1 - 
//1 - 
//   

FBD10_run:
//========       ========= 
 rcall Read_cfg_Load_Uz1                                   ; 
//=============   FBD  ==================
// ldi  A, 0b00000001                               ;
 com  Uz1L                                        ;
 and  Uz1L, One                                     ;and
//=============    ==================
 clr   Uz1H                                       ; 
 rcall Read_cfg_Save_Uz1                                   ; 
 ret;

#else 
 #error redeclared FBD10 __FILE__
#endif
//********************************************************************************************************
#ifndef _FBD11_
#define _FBD11_ FBD11
#message define FBD11 time on
; FBD 
;1   -
;2  -
;1   -
; :
;  1   - 
;  2  -  

FBD11_run:
  ld    A,    X+                                   ;  
  ld    Uz1L, X+                                   ;  Lw
  ld    Uz1H, X+                                   ;  Hw
  sbiw  XL,   3                                    ; 

  rcall Read_cfg_Load_Uz2                          ;
  rcall Read_cfg                                   ;   Lw
  mov   C, Addr_Data                               ;   Lw
  rcall Read_cfg                                   ;   Hg
  mov   D, Addr_Data                               ;   Hg

//*****************   **********************
  sbrs Uz2L, 0
  rjmp FBD11_clear
//***********    **********************
  tst  A                     //  ( )
  brpl FBD11_start           //  ( ) 
//*************    *************************
  rcall Timer_Diff           //  
  cp   ZL,  C                //
  cpc  ZH,  D                //
  brmi FBD11_set_zero
  mov Uz3L, One              // 1

FBD11_end:
  st   X+,   A               //
  st   X+,   Uz1L            //
  st   X+,   Uz1H            //
  rcall Read_cfg_Save_Uz3    // 
  ret

FBD11_start:
  ori  A,   0b10000000                     //(   )
  lds Uz1L, TimerCounter0_DATA_RAM+1       //  
  lds Uz1H, TimerCounter0_DATA_RAM+2       //  

FBD11_set_zero:
  mov  Uz3L, Zero              // 0
  rjmp FBD11_end

FBD11_clear:
  andi A, 0b01111111           //(   )
  mov  Uz3L, Zero              // 0
  rjmp FBD11_end



#else 
 #error redeclared FBD11 __FILE__
#endif
//********************************************************************************************************
#ifndef _FBD12_
#define _FBD12_ FBD12
#message define FBD12 (mulF)__FILE__

//  FDB  3 
//1 -  1
//1 -  2
//1 - 
//  4 

//   
#define _real_mul_fun_ 

FBD12_run:
//=====       ===== 
 rcall Read_Cfg_Load_ABCD   //  1 ( 1)
 rcall Read_Cfg_Load_EFGH   //  2 ( 2)
//=============   FBD  =============== 
 rcall real_mulF            //
//=============    ==================    
  mov Uz1L, XL              // 
  mov Uz1H, XH              // 
  rcall Read_cfg_Save_Uz1   // 
  st    X+, D               // 
  st    X+, C               // 
  st    X+, B               // 
  st    X+, A               // 
 ret

#else 
 #error redeclared FBD12 __FILE__
#endif
//********************************************************************************************************
#ifndef _FBD13_
#define _FBD13_ FBD13
#message define FBD13 (subF)__FILE__

//  FDB  3 
//1 -  1
//1 -  2
//1 - 
//  4 

//    
#define _real_add_sub_fun_ 

FBD13_run:
//=====       ===== 
 rcall Read_Cfg_Load_ABCD   //  1 ( 1)
 rcall Read_Cfg_Load_EFGH   //  2 ( 2)
//=============   FBD  =============== 
 rcall real_SubF            //
//=============    ==================    
  mov Uz1L, XL              // 
  mov Uz1H, XH              // 
  rcall Read_cfg_Save_Uz1   // 
  st    X+, D               // 
  st    X+, C               // 
  st    X+, B               // 
  st    X+, A               // 
 ret

#else 
 #error redeclared FBD13 __FILE__
#endif
//********************************************************************************************************
#ifndef _FBD14_
#define _FBD14_ FBD14
#message define FBD14 (LCD_out_real)__FILE__

//  FDB  2 
//1 -  1
//1 - 
//1 -  
//   


FBD14_run:
//========       ========= 
 rcall Read_cfg_Load_Uz1    //   
 rcall Read_cfg             //   
 mov   H, Addr_Data         //  
 rcall Read_cfg             // 
 mov   G, Addr_Data         // 
//=============   FBD  ==================
  rcall bcdfp               //  
  ret;



#else 
 #error redeclared FBD14 __FILE__
#endif
//============================================
 ;                 
shift_CBAFED_G:   
        lsl C
        rol B
        rol A
        rol F
        rol E
        rol D
        dec G
        brne shift_CBAFED_G 
        ret
;  
shift_ABC_G:
        lsr A
        ror B
        ror C
        dec G
        brne shift_ABC_G 
        ret

out_G_LCD_pos_H_inc:
      andi G,  $0f
      subi G,  0xD0
      brtc out_char_G_LCD_pos_H_inc   //    
      cpi  G, 0x30                    //   
      brne out_char_G_LCD_pos_H_inc
      ret
out_char_G_LCD_pos_H_inc:
      clt 
      mov  Addr_Data, G
      mov  ZL, H
      rcall LCD_out_char      
      inc  H
      dec  Uz1L
      brne LCD_out_char_no_complet
      pop  G               // 
      pop  G               // 
LCD_out_char_no_complet:
      ret

//============================================

bcdfp: 
        mov ZL, Uz1L        //  
        mov ZH, Uz1H        //  
        mov Uz1L, G         //  
        ld  C,  Z+          //  
        ld  B,  Z+          //  
        ld  A,  Z+          //  
        ld  G,  Z+          //  
; 
        bst  G, 7            //  T  
        ori  G, $80          //
        lsl  A               // ABC-  
        rol  G               //
        ror  A               //
        subi G, 126          // G - 
; 
        clr D
        clr F
        clr E  
;  (    )
        tst  G
        breq  Next_real_LCD    
        mov   Addr_Data, G
        sbrs  Addr_Data, 7               //   
        rcall shift_CBAFED_G             //  
        neg   G
        sbrc  Addr_Data, 7               //   
        rcall shift_ABC_G                //  
Next_real_LCD:
; 
        brtc LCD_real_no_negative_sign   // 
        ldi  G, 0x2D                     // 
        rcall out_char_G_LCD_pos_H_inc   // 
LCD_real_no_negative_sign:
;bcd-  
        set   

        ldi     G,    -1
int_loop_1:
        inc     G
        subi    F, low(100000)
        sbci    E, byte2(100000)
        sbci    D, byte3(100000)
        brsh    int_loop_1
        subi    F, low(-100000)
        sbci    E, byte2(-100000)
        sbci    D, byte3(-100000)
        rcall   out_G_LCD_pos_H_inc   // 

        ldi     G,    -1
int_loop_2:
        inc     G
        subi    F, low(10000)
        sbci    E, byte2(10000)
        sbci    D, byte3(10000)
        brsh    int_loop_2
        subi    F, low(-10000)
        sbci    E, byte2(-10000)
        sbci    D, byte3(-10000)
        rcall   out_G_LCD_pos_H_inc   // 

        ldi     G,    -1
int_loop_3:
        inc     G
        subi    F, low(1000)
        sbci    E, byte2(1000)
        brsh    int_loop_3
        subi    F, low(-1000)
        sbci    E, byte2(-1000)
        rcall   out_G_LCD_pos_H_inc   // 

        ldi     G,    -1
int_loop_4:
        inc     G
        subi    F, 100 
        sbci    E, byte2(100) 
        brsh    int_loop_4
        subi    F, -100 
        sbci    E, byte2(-100) 
        rcall   out_G_LCD_pos_H_inc   // 

        ldi     G,    -1
int_loop_5:
        inc     G
        subi    F, 10
        brsh    int_loop_5 
        subi    F, -10 
        rcall   out_G_LCD_pos_H_inc   // 
      
        mov  G,  F
        clt	 
        rcall   out_G_LCD_pos_H_inc   // 
        clr F
; 
        ldi  G, 0x2E                     // 
        rcall out_char_G_LCD_pos_H_inc   // 
;bcd-   
f_conv: 
       ldi G, 24
f_conv1: 
       lsr A
       ror B
       ror C
       ror D
       ror E
       ror F
         
      sbrc F,7
      subi F,$30
      sbrc F,3
      subi F,$03
      sbrc E,7
      subi E,$30
      sbrc E,3
      subi E,$03
      sbrc D,7
      subi D,$30
      sbrc D,3
      subi D,$03

      dec G
      brne f_conv1          

; bcd-  
      mov G,  D
      swap G 
      rcall out_G_LCD_pos_H_inc
      mov G, D
      rcall out_G_LCD_pos_H_inc
      mov  G,E
      swap G 
      rcall out_G_LCD_pos_H_inc
      mov  G,E
      rcall out_G_LCD_pos_H_inc
      mov G,F
      swap G  
      rcall out_G_LCD_pos_H_inc
      mov G, F
      rcall out_G_LCD_pos_H_inc 
      ret
//********************************************************************************************************
//=====================================   C:\Horizont\Configurator\Runtime\HR_AVR\library\lib_real.inc   =====================================
/*
 *  library of real numbers version 1.1
 *
 *  Created: 06.01.2014
 *  Author: Lihouzov Evgeny
 */

#ifdef _real_add_sub_fun_
#define _lib_real_
#endif

#ifdef _real_mul_fun_
#define _lib_real_
#endif

#ifdef _real_div_fun_
#define _lib_real_
#endif

#ifdef _real_Int16ToReal_fun_
#define _lib_real_
#endif

#ifdef _lib_real_
#message define Include library for real numbers in __FILE__

//  
Read_Cfg_Load_Pointer_Z:
     rcall Read_cfg                  //  
     rcall Set_Adres_Uzl             //  Z   
     ld    Addr_Data,  Z+            // 
     ld    ZH, Z                     // 
     mov   ZL, Addr_Data             // 
     ret

// ABCD 
Read_Cfg_Load_ABCD:
 rcall Read_Cfg_Load_Pointer_Z   // 
     ld  D, Z+                       // 
     ld  C, Z+                       // 
     ld  B, Z+                       // 
     ld  A, Z+                       // 
     ret

// EFGH 
Read_Cfg_Load_EFGH:
 rcall Read_Cfg_Load_Pointer_Z   // 
     ld  H, Z+                       // 
     ld  G, Z+                       // 
     ld  F, Z+                       // 
     ld  E, Z+                       // 
     ret

//   ABCD    
lib_real_rec: 
     lsl B       //     
     rol A       //  
     lsr B       //   
     ori B, 0x80 //  1  
     ret 

//     T  
lib_real_pack: 
    lsl  B     //    
    lsr  A     //  
    ror  B     //   
    bld  A, 7  // 
    ret 

//  
lib_real_swap_ABCD_EFGH: 
    eor A, E   //  A, E
    eor E, A 
    eor A, E 
    eor B, F   //  B, F
    eor F, B 
    eor B, F 
    eor C, G   //  C, G
    eor G, C 
    eor C, G 
    eor D, H   //  D, H
    eor H, D 
    eor D, H 
    ret
 
//C BCD  0 
lib_real_cp_ABCD_0: 
    mov ZL, A 
    or  ZL, B 
    or  ZL, C 
    or  ZL, D // BCD=0   Z=l 
    ret        

//C EFGH  0
lib_real_cp_EFGH_0: 
    mov ZL, E 
    or  ZL, F 
    or  ZL, G 
    or  ZL, H // BCD=0   Z=l 
    ret   

//  24-   ABCD
lib_real_shift_ABCD: 
    lsr B 
    ror C 
    ror D 
    clc 
    ret 

// ABCD (ABCD=0)
lib_real_clear_ABCD: 
    clr A 
    clr B 
    clr C 
    clr D 
    ret 

#endif


#ifdef _real_add_sub_fun_
#message Include AddF function in __FILE__
#message Include SubF function in __FILE__

//*****         *****// 
real_AddF:                        //  
    mov ZL, A                     // 
    eor ZL, E                     // 
    brpl real_AddFl               // 
    subi E, 0x80                  // 
    rjmp real_SubF                //  

real_AddFl: 
    rcall lib_real_cp_EFGH_0      // EFGH  0 
    breq real_AddF_Quit           // 
    rcall lib_real_cp_ABCD_0      // ABCD  0 
    brne real_AddF2               // 
    rcall lib_real_swap_ABCD_EFGH // BCD  EFGH 
    ret                           // 

real_AddF2: 
    bst  A, 7                     //  T=A.7 
    rcall lib_real_rec            //  ABDC
    rcall lib_real_swap_ABCD_EFGH // BCD  EFGH 
    rcall lib_real_rec            //  ABDC 
    mov ZL, A                     //  
    sub ZL, E                     //           
    brpl real_AddF3               //,   ABCD>EFGH 
    rcall lib_real_swap_ABCD_EFGH // BCD  EFGH 
    mov ZL, A                     //  
    sub ZL, E                     //    

real_AddF3: 
    breq real_AddF6               //,     
    cpi ZL,24                     // c   24 
    brmi real_AddF4               // 
    rjmp real_AddF7               //    

real_AddF4: 
    rcall lib_real_swap_ABCD_EFGH // BCD  EFGH  

real_AddF5: 
    rcall lib_real_shift_ABCD     //   ABCD 
    inc A                         //    
    dec ZL                        //   
    brne real_AddF5 

real_AddF6: 
    add D, H                      //  
    adc C, G                      // 
    adc B, F                      // 
    brcc real_AddF7               //   
    inc A                         //  
    breq real_AddF_Quit           //    ( C)
    rcall lib_real_shift_ABCD     //   ABCD 

real_AddF7: 
    rcall lib_real_pack           // 
real_AddF_Quit:
    ret                           // 

//==============================================================//
real_SubF:                        //  
    mov ZL, A                     // 
    eor ZL, E                     // 
    brpl real_SubFl               //   
    subi E, 0x80                  //  2-       
    rjmp real_AddF                //   

real_SubFl: 
    rcall lib_real_cp_EFGH_0      // EFGH  0 
    breq real_SubF_Quit           // 
    rcall lib_real_cp_ABCD_0      // ABCD  0  
    brne real_SubF2               // 
    rcall lib_real_swap_ABCD_EFGH // BCD  EFGH  
    subi A, 0x80                  //  1-  
    ret                           // 

real_SubF2: 
    bst  A, 7                     //  T=A.7 
    rcall lib_real_rec            //  ABDC
    rcall lib_real_swap_ABCD_EFGH // BCD  EFGH 
    rcall lib_real_rec            //  ABDC 
    mov ZL, E                     //  
    sub ZL, A                     //           
    brne real_SubF3               //,   
    cp F, B                       // 
    brne real_SubF3               //,    
    cp G, C                       // 
    brne real_SubF3               //,   
    cp H, D                       // 
    brne real_SubF3               //,   
    rcall lib_real_clear_ABCD     //  ABCD=0
    ret                           // 
 
real_SubF3: 
    brcc real_SubF4               //,  1-   
    rcall lib_real_swap_ABCD_EFGH // BCD  EFGH  
    bld  ZL, 7                    //   
    subi ZL, 0x80                 //   
    bst  ZL, 7                    //   
 
real_SubF4: 
    mov ZL, E                     //   
    sub ZL, A                     //  
    breq real_SubF7               //    
    cpi ZL, 24                    // c   24 
    brmi real_SubF6               //  
    rcall lib_real_swap_ABCD_EFGH // BCD  EFGH 
    rjmp real_SubF9               // 
 
real_SubF6:
    rcall lib_real_shift_ABCD     //   ABCD 
    dec ZL                        //   
    brne real_SubF6               //      
    
real_SubF7: 
    sub H, D                      // 
    mov D, H                      // EFGH->ABCD
    sbc G, C                      //    
    mov C, G                      // EFGH->ABCD 
    sbc F, B                      //    
    mov B, F                      // EFGH->ABCD                  
    mov A, E                      // EFGH->ABCD 

real_SubF8: 
    sbrc B, 7                     //   
    rjmp real_SubF9               //,   , 
    dec A                         //,   , 
    cpi A, 0xFF                   // , 
    sec                           //    1, 
    breq real_SubF_Quit           //     C=1 
    lsl D                         //  ABCD  
    rol C                         //  ABCD 
    rol B                         //  ABCD 
    clc                           //  C=0
    rjmp real_SubF8               // 
 
real_SubF9: 
    rcall lib_real_pack           // 
real_SubF_Quit: 
    ret                           //    

#endif

#ifdef _real_mul_fun_
#message Include mulF function in __FILE__
real_MulF:
    clr Uz1L                      //   
    clr Uz1H                      //  
    clr Uz2L                      //  
    clr Uz2H                      //  
    rcall lib_real_cp_EFGH_0      // EFGH  0 
    breq real_MulF_Quit           // 
    rcall lib_real_cp_ABCD_0      // ABCD  0  
    breq real_MulF_Quit           // 

    mov ZL, A                     //   
    eor ZL, E                     //  
    bst ZL, 7                     //    

    rcall lib_real_rec            //  ABDC
    rcall lib_real_swap_ABCD_EFGH // BCD  EFGH 
    rcall lib_real_rec            //  ABDC 
 
  //  mov  Uz1L, E                  //  
    add  A, E                     //  
    brcs real_MulFl 
    subi A, 127                   //   
    brcc real_MulF2 
    rjmp real_MulF_Quit
 
real_MulFl: 
    ldi ZL, 129                   //     
    add A,  ZL                    // -25+129=-127 
    brcs real_MulF_Quit           //
  
real_MulF2:                       //  (C=AxB)
    ldi ZL, 24                    //   
real_MulF3:
    ror F                         //  
    ror G                         //     
    ror H                         //
    brcc real_MulF4               //    1, 
    add Uz2H, D                   //  (L-), 
    adc Uz2L, C                   //  - 
    adc UZ1H, B                   //  - 

real_MulF4: 
    dec ZL                        //   
    brne real_MulF5               //  ,  
    rjmp real_MulF6 

real_MulF5:
    ror Uz1H                      //   
    ror Uz2L                      //  
    ror Uz2H                      //  
    rjmp real_MulF3 
 
real_MulF6:                       // 
    brcc real_MulF7               //  
    ror Uz1H                      //
    ror Uz2L                      //
    ror Uz2H                      //
    inc A                         //  
    sec                           //C=l 
    breq real_MulF_Quit           //    
real_MulF7:  
    mov D, Uz2H                   //
    mov C, Uz2L                   //
    mov B, Uz1H                   //
//    mov A, Uz1L                   // 
    rcall lib_real_pack           // 

real_MulF_Quit: 
    ret                           //  

#endif

#ifdef _real_div_fun_
#message Include DivF function in __FILE__

real_DivF:
    clr Uz1L                      //   
    clr Uz1H                      //  
    clr Uz2L                      //  
    clr Uz2H                      //  
    rcall lib_real_cp_EFGH_0      // EFGH  0 
    sec                           //C=1
    breq real_DivF_Quit           // 
    rcall lib_real_cp_ABCD_0      // ABCD  0  
    clc                           //C=0
    breq real_DivF_Quit           // 

    mov ZL, A                     //   
    eor ZL, E                     //  
    bst ZL, 7                     //    

    rcall lib_real_rec            //  ABDC
    rcall lib_real_swap_ABCD_EFGH // BCD  EFGH 
    rcall lib_real_rec            //  ABDC 
    rcall lib_real_swap_ABCD_EFGH //     
 
    sub A, E                      //  
    brcc real_DivFl               //  
    ldi ZL, 127                   //  
    add A, ZL                     //
    brcs real_DivF2               //    
    sec                           // 
    rjmp real_DivF_Quit           //

real_DivFl: 
    ldi ZL, 127                   //   
    add A,  ZL                    //
    brcs real_DivF_Quit           //   
  
real_DivF2:                       //  (C=A/B)
    clr E                         //   
    ldi ZL, 24                    //   
real_DivF3: 
   // push mAL ;  mA 
   // push mAM ; ()   
   // push mAH 

    cp  D, H                      //
    cpc C, G                      //
    cpc B, F                      //
    cpc E, Zero

    brcc real_DivF4 
   // pop mAH /  
   // pop mAM ;" , .. mA<mB 
   // pop mAL                    //C=1
    clc                          //   0 
    rjmp real_DivF5 

real_DivF4:
    sub D, H                     //
    sbc C, G                     //
    sbc B, F                     //
    sbc E, Zero                  //
    sec                          //   1 

real_DivF5: 
    rol Uz2H                      //   
    rol Uz2L                      //  
    rol Uz1H                      //  
    clc 
    rol D                         //   
    rol C                         //  
    rol B                         //  
    rol E                         //  
    dec ZL                        //   
    brne real_DivF3               //,  ZL>0 
 
    sbrc Uz1H, 7                  // 
    rjmp real_DivF6               //  
    rol Uz2H                      // 
    rol Uz2L                      //   
    rol Uz1H                      //  
    dec A                         //   
    cpi A,0xFF 
    sec                           //C=1 
    breq real_DivF_Quit           //    
real_DivF6: 
   // mov , /  
    mov D, Uz2H                  // 
    mov C, Uz2L                  //
    mov B, Uz1H                  //
real_DivF7: 
    rcall lib_real_pack          //  
real_DivF_Quit: 
    ret                          //   

#endif


#ifdef _real_Int16ToReal_fun_
#message Include Int16ToReal function in __FILE__

real_Int16ToReal:                 // Int16(Uz1H,Uz1L)  . (ABCD)
    clr  A                        // 
    mov  B, Uz1H                  // 
    mov  C, Uz1L                  // 
    clr  D                        // 
    rcall lib_real_cp_ABCD_0      // ABCD  0  
    breq real_Int16ToReal_Quit_2  // 
	ldi  A, 127+15                // 
    bst  B, 7                     //   
    brtc real_Int16ToReal1        // 
    com  B                        // 
    neg  C                        // 
real_Int16ToReal1: 
    sbrc B, 7                     //   
    rjmp real_Int16ToReal_Quit    //,   , 
    dec A                         //,   , 
    lsl D                         //  ABCD  
    rol C                         //  ABCD 
    rol B                         //  ABCD 
    clc                           //  C=0
    rjmp real_Int16ToReal1        // 
real_Int16ToReal_Quit: 
    rcall lib_real_pack           // 
real_Int16ToReal_Quit_2: 
    ret                           //   
#endif

//=====================================   C:\Horizont\Configurator\Runtime\HR_AVR\library\lib_one_wire.inc   =====================================
/*
 *  library of one_wire version 1.1
 *
 *  Created: 28.04.2016
 *  Author: Lihouzov Evgeny
 */

#ifdef _lib_one_wire_
#message define Include library for one_wire in __FILE__
//==========  
//  C  -  
//  D  -  
//  E  -  
//  F  -  
//  G  - C   /  
//  H  -     
//  B  - CRC8                                                  
 rcall Read_cfg_Load_Uz1         // 
 mov ZL, Uz1L
 mov ZH, Uz1H
//  Uz1L -  FBD 
//  Uz1H -  FBD 
//  G    -  
//  Uz2H -  (0000X000)
//  Z    -    (PINC)

One_wire_begin:   //=======     =========
  BST One, 0                     //  
//=============================  ===========================  
  andi D, 0b11111111             // 
  breq One_wire_send_reset
  dec  D                         // 
  brne One_wire_pause_end
  tst  G
  breq One_wire_pause_end
  ldi  D, 255
  dec  G
One_wire_pause_end:
  ret
//================    ========================

//====================   ======================
One_wire_send_reset:
  cpi  C, 0x80
  brmi One_wire_send_byte
  ldi  A, 0b01000000
  and  A, C
  breq One_wire_reset_0
  rcall One_wire_cfg_in           //    
  rcall One_wire_set1             // 1
  ldi   d, 245                    //
  rcall One_wire_wait             //    90*10^-6  
  ld   A, Z                       //  
  and  A, Uz2H                    //  
  brne One_wire_error             //  
  andi C, 0b00111111              // 
  ldi   D, 2                      // 
  ret
One_wire_reset_0:
  rcall One_wire_cfg_out          //    
  rcall One_wire_set0             // 0
  ori   C, 0b01000000             //       
  ldi   D, 2                      //   
  ret 
//===================  /  =====================
One_wire_send_byte:
  cpi  E, 0
  breq One_wire_send_paket
  rcall One_wire_cfg_out
  rcall One_wire_set0
  mov A, F
  and A, E
  ldi D, 13                     //10*10^-6 
  brne One_wire_send_bit_next
  ldi D, 200                    //90*10^-6 
One_wire_send_bit_next:
  or  F, E                        // 
  eor F, E                        //   
  rcall One_wire_wait
  rcall One_wire_cfg_in
  rcall One_wire_set1
  ldi D, 1                        //  
  rcall One_wire_wait             //  
  or   F, E                       //  1
  mov  Addr_Data, One             // 1
  ld   A, Z                       //  
  and  A, Uz2H                    //  
  brne One_wire_send_bit_next2
  eor   F, E                      //  
  clr   Addr_Data                 // 0
One_wire_send_bit_next2: 
  rcall One_wire_CRC_8_calc_bit   //B-CRC8, Addr_Data (0b0000000X)-  , A-     
  lsl  E                          //    
  breq One_wire_save_recive_byte
  ret
One_wire_save_recive_byte:
  mov  A, ZL
  ldi  ZL, Low(DS18B20_DATA_RAM)  //  
  ldi  ZH, High(DS18B20_DATA_RAM) //  
  add  ZL, G
  adc  ZH, Zero
  st   -Z, F                      //  
  mov  ZL, A 
  clr  ZH
  ret
//==================   ==================
One_wire_send_paket:
  cpi  H, 0
  breq One_wire_end
  dec  H
  mov  A, ZL
  ldi  ZL, Low(DS18B20_DATA_RAM)  //  
  ldi  ZH, High(DS18B20_DATA_RAM) //  
  add  ZL, G
  adc  ZH, Zero
  ld   F, Z                       //  
  ldi  E, 0x01                    //  
  mov  ZL, A 
  clr  ZH
  inc  G
  ret
//==================  =============================== 
One_wire_error:
  ori D, 0x80      
One_wire_end:
  BST Zero, 0                    //  
  ret

//***************   *****************
One_wire_cfg_out:
 ldd  A, Z+1
 or   A, Uz2H
 std  Z+1, A
 ret  
One_wire_cfg_in:
 ldd  A, Z+1
 or   A, Uz2H
 eor  A, Uz2H
 std  Z+1, A
 ret 
                                        
One_wire_set1:
 ldd  A, Z+2
 or   A, Uz2H
 std  Z+2, A
 ret  

One_wire_set0:
 ldd  A, Z+2
 or   A, Uz2H
 eor  A, Uz2H
 std  Z+2, A
 ret 

One_wire_wait:
 dec  D
 brne One_wire_wait
 ret

;***************************************************************
;    (CRC-8)   
;  - Addr_Data 0b0000000X
;  - B -   CRC-8
;  - A, B 
;***************************************************************
One_wire_CRC_8_calc_bit:     //B-CRC8, Addr_Data (0b0000000X)-  , A-  
	//	clr		w1CRCtmp	   //    CRC
	//	bld		w1CRCtmp,0	   //  
		eor		Addr_Data, B	   //    
		ror		Addr_Data	   // - "0"  "1"
		mov		Addr_Data, B       //  
		brcc	One_wire_CRC_8_next        //  "0" - 
		ldi		A, $18  	   //  "1" -  
		eor		Addr_Data, A       //   
One_wire_CRC_8_next:
		ror		Addr_Data	   //     
		mov		B, Addr_Data	   //   
		ret

#endif
//=====================================   C:\Horizont\Configurator\Runtime\HR_AVR\library\lib_modbus.inc   =====================================
/*
 *  library of modbus version 1.1
 *
 *  Created: 28.04.2015
 *  Author: Lihouzov Evgeny
 */

#ifdef _lib_modbus_
#message define Include library for modbus protocol in __FILE__

 //=== FIFO ,   ===
 //==  Z -   -
 //==  G -  -
 //==  H -  /   - 

//*********************************************************************
modbus_FIFO_write_buf:    //Z- G- H  ( E,F )
  ld   E, Z+            ; 
  ld   F, Z             ; 

  inc  F
  cp   F, G
  brne modbus_FIFO_write_buf_1
  clr  F
modbus_FIFO_write_buf_1:
  
  cp E, F                  ;
  brne modbus_FIFO_write_buf_2  ;
  set                      ;
  ret                      ;
modbus_FIFO_write_buf_2:

  mov E,   F
  ld  F,   Z
  st  Z+,  E

  add ZL, F
  adc ZH, Zero
  st  Z,  H           ;
  clt                 ;
  ret                 ;
//*********************************************************************
modbus_FIFO_read_buf:   //Z- G- H  ( E,F )
  ld   E, Z+            ; 
  ld   F, Z             ; 

  cp E, F                 ;
  brne modbus_FIFO_read_buf_1  ;
  set                     ;
  ret                     ;
modbus_FIFO_read_buf_1:

  mov  F, E
  inc  E
  cp   E, G
  brne modbus_FIFO_read_buf_2
  clr  E
modbus_FIFO_read_buf_2:
  
  st  -Z,  E
  adiw Z,  2

  add ZL, F
  adc ZH, Zero
  ld  H,  Z           ;
  clt                 ;
  ret                 ;
//*********************************************************************
modbus_line_write_buf:    //Z- G- H  ( F )
  ld   F, Z                ; 
  set                      ;
  cp   F, G
  breq modbus_line_write_buf_end
  mov  E, F                ; 
  inc  E                   ; 
  st   Z+, E               ; 
  add  ZL, F
  adc  ZH, Zero
  st   Z,  H               ;
  clt                      ;
modbus_line_write_buf_end:
  ret                 ;

//*********************************************************************
 //===  CRC 16   ===
 //==  Z -   
 //==  E -    CRC_16

modbus_CRC_16_calc:    //Z- E- ( A,B,D,E,F ) BA=_16
 ldi   A,  0b11111111             //  CRC_16
 ldi   B,  0b11111111             //  CRC_16
 ldi   D,  0b10100000             //  
modbus_CRC_16_Read_Byte:
 ld    F,  Z+                     //  
 eor   A,  F                      //  XOR
 LDI   F,  8                      //  
modbus_CRC_16_Loop_Bit:
 lsr B                            //   CRC 
 ror A                            //   CRC 
 brcc modbus_CRC_16_Next_Loop_Bit
 eor  B, D                        // CRC  
 eor  A, One                      // CRC  
modbus_CRC_16_Next_Loop_Bit:
 dec  F                           //  
 brne modbus_CRC_16_Loop_Bit      //  
 dec  E                           //  
 brne modbus_CRC_16_Read_Byte     //  
 ret    //===   BA=_16  ===

//*********************************************************************
 //===     ===
 //==  Z -   
 //==  A- 

modbus_run_comand:    //Z- A-  ( A,B,C,D,E,F ) BA=_16
  ld   E,  Z                 ; 
  st   Z+,  Zero             ;   
  cpi  E,  4                 ; 
  brcs modbus_run_comand_end ; 
  ld   F,  Z+                ; 
  cp   F,  A                 ; 
  brne modbus_run_comand_end ; 
  
  ld   C, Z+                 ;   
  mov  G, ZL                 ;   
  mov  H, ZH                 ;   
  sbiw ZL, 2                 ;   

  rjmp modbus_CRC_16_calc    ; CRC

  ld   F, Z+                 ; CRC
  cp   B, F                  ; CRC
  brne modbus_run_comand_end ; CRC

  ld   F, Z+                 ; CRC
  cp   A, F                  ; CRC
  brne modbus_run_comand_end ; CRC

  ldi  ZL, Low (modbus_function)
  ldi  ZL, Low (modbus_function)
  ijmp                       ; 

modbus_run_comand_end:
 ret  

//  
modbus_function:
 rjmp modbus_illegal_function      //1-READ COIL STATUS	      (ON/OFF)   . 
 rjmp modbus_illegal_function      //2-READ COIL STATUS	      (ON/OFF)   . 
 rjmp modbus_illegal_function      //3-READ COIL STATUS	      (ON/OFF)   . 
 rjmp modbus_illegal_function      //4-READ COIL STATUS	      (ON/OFF)   . 
 rjmp modbus_illegal_function      //5-READ COIL STATUS	      (ON/OFF)   . 
 rjmp modbus_illegal_function      //6-READ COIL STATUS	      (ON/OFF)   . 
 rjmp modbus_illegal_function      //7-READ COIL STATUS	      (ON/OFF)   . 
 rjmp modbus_illegal_function      //8-READ COIL STATUS	      (ON/OFF)   . 
 rjmp modbus_illegal_function      //9-READ COIL STATUS	      (ON/OFF)   . 
 rjmp modbus_illegal_function      //10-READ COIL STATUS	      (ON/OFF)   . 
 rjmp modbus_illegal_function      //11-READ COIL STATUS	      (ON/OFF)   . 
 rjmp modbus_illegal_function      //12-READ COIL STATUS	      (ON/OFF)   . 
 rjmp modbus_illegal_function      //13-READ COIL STATUS	      (ON/OFF)   . 
 rjmp modbus_illegal_function      //14-READ COIL STATUS	      (ON/OFF)   . 
 rjmp modbus_illegal_function      //15-READ COIL STATUS	      (ON/OFF)   . 
 rjmp modbus_illegal_function      //16-READ COIL STATUS	      (ON/OFF)   . 
 rjmp modbus_illegal_function      //17-READ COIL STATUS	      (ON/OFF)   . 
 rjmp modbus_illegal_function      //18-READ COIL STATUS	      (ON/OFF)   . 
 rjmp modbus_illegal_function      //19-READ COIL STATUS	      (ON/OFF)   . 

#endif
//=====================================   C:\Horizont\Configurator\Runtime\HR_AVR\library\lib_EEPROM.inc   =====================================
/*
 *  library of EEPROM version 1.2
 *
 *  Created: 10.02.2017
 *  Author: Lihouzov Evgeny
 */

#ifdef _lib_EEPROM_rd_wr_byte_
#message define Include library for EEPROM in __FILE__

//*********************************************************************
EEPROM_read_byte:            //F,E- A 
#if defined(_M328DEF_INC_)||defined(_M328PDEF_INC_) 
   sbic EECR, EEPE           //Wait for completion of previous write
#else
   sbic EECR, EEWE
#endif
   rjmp EEPROM_read_byte     //Wait for completion of previous write

.if EEPROMEND>=256
   out  EEARL, E             //Set address in address register
   out  EEARH, F             //Set address in address register
.else
   out  EEARL, E             //Set address in address register
.endif   
   sbi  EECR,  EERE          //Start eeprom read by writing EERE
   in   A,     EEDR          //Read data from data register
  ret                        //
//*********************************************************************
EEPROM_write_byte:           //F,E- A 
#if defined(_M328DEF_INC_)||defined(_M328PDEF_INC_) 
   sbic EECR, EEPE           //Wait for completion of previous write
#else
   sbic EECR, EEWE
#endif
   rjmp EEPROM_write_byte    //Wait for completion of previous write
.if EEPROMEND>=256
   out  EEARH, F             //Set address in address register
   out  EEARL, E             //Set address in address register
.else
   out  EEAR,  E             //Set address in address register
.endif 
   out EEDR,   A             //Write data (r16) to data register
#if defined(_M328DEF_INC_)||defined(_M328PDEF_INC_)
   sbi EECR,EEMPE            //Write logical one to EEMPE
   sbi EECR,EEPE             //Start eeprom write by setting EEPE
#else
   sbi EECR,   EEMWE         //Write logical one to EEMPE
   sbi EECR,   EEWE          //Start eeprom write by setting EEPE
#endif
   
  ret                        //
//*********************************************************************
#endif
FBD0:  .DB  0x22, 0x2C, 0x10, 0x01, 0x04, 0x0C, 0x2D, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x54, 0x45, 0x4D, 0x2D, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x4C, 0x49, 0x4D, 0x00, 0x01, 0x02, 0x03, 0x04, 0x05 //f:48 m:2  LCD_hd44780_2x16.inc
FBD1:  .DB  0x08, 0x03                                    //f:2 m:0  port_B.inc
FBD2:  .DB  0x09, 0x02                                    //f:2 m:0  port_B.inc
FBD3:  .DB  0x0A, 0x01                                    //f:2 m:0  port_B.inc
FBD4:  .DB  0x0B, 0x00                                    //f:2 m:0  port_B.inc
FBD5:  .DB  0x0C, 0x05                                    //f:2 m:0  port_B.inc
FBD6:  .DB  0x0D, 0x04                                    //f:2 m:0  port_B.inc
FBD7:  .DB  0x80, 0x40                                    //f:2 m:0  ADC_ATmega8a_v1_conf.inc
FBD8:  .DB  0x48, 0xE1, 0xFA, 0x3E, 0x09, 0x00            //f:5 m:4  real_const.inc
FBD9:  .DB  0x00, 0x00, 0x00, 0x00, 0x0A, 0x00            //f:5 m:4  real_const.inc
FBD10: .DB  0x0B, 0x00                                    //f:2 m:0  ADC_ATmega8a_v1_pin.inc
FBD11: .DB  0x0C, 0x01                                    //f:2 m:0  ADC_ATmega8a_v1_pin.inc
FBD12: .DB  0x0B, 0x0C, 0x0D, 0x00                        //f:3 m:0  integer_less.inc
FBD13: .DB  0x0C, 0x0E                                    //f:2 m:4  real_Int16ToSingl.inc
FBD14: .DB  0x48, 0xE1, 0xFA, 0x3E, 0x11, 0x00            //f:5 m:4  real_const.inc
FBD15: .DB  0x00, 0x00, 0x00, 0x00, 0x12, 0x00            //f:5 m:4  real_const.inc
FBD16: .DB  0x03, 0x00, 0x31, 0x00                        //f:3 m:0  const.inc
FBD17: .DB  0x48, 0xE1, 0xFA, 0x3E, 0x17, 0x00            //f:5 m:4  real_const.inc
FBD18: .DB  0x00, 0x00, 0x00, 0x00, 0x18, 0x00            //f:5 m:4  real_const.inc
FBD19: .DB  0x1A, 0x02                                    //f:2 m:0  ADC_ATmega8a_v1_pin.inc
FBD20: .DB  0x1B, 0x03                                    //f:2 m:0  ADC_ATmega8a_v1_pin.inc
FBD21: .DB  0x48, 0xE1, 0xFA, 0x3E, 0x1E, 0x00            //f:5 m:4  real_const.inc
FBD22: .DB  0x00, 0x00, 0x00, 0x00, 0x1F, 0x00            //f:5 m:4  real_const.inc
FBD23: .DB  0x1B, 0x20                                    //f:2 m:4  real_Int16ToSingl.inc
FBD24: .DB  0x48, 0xE1, 0xFA, 0x3E, 0x24, 0x00            //f:5 m:4  real_const.inc
FBD25: .DB  0x00, 0x00, 0x00, 0x00, 0x25, 0x00            //f:5 m:4  real_const.inc
FBD26: .DB  0x26, 0x04                                    //f:2 m:0  ADC_ATmega8a_v1_pin.inc
FBD27: .DB  0x48, 0xE1, 0xFA, 0x3E, 0x29, 0x00            //f:5 m:4  real_const.inc
FBD28: .DB  0x00, 0x00, 0x00, 0x00, 0x2A, 0x00            //f:5 m:4  real_const.inc
FBD29: .DB  0x2C, 0x05                                    //f:2 m:0  ADC_ATmega8a_v1_pin.inc
FBD30: .DB  0x83, 0x03                                    //f:2 m:0  time_counter_milliseconds.inc
FBD31: .DB  0x26, 0x2C, 0x2E, 0x00                        //f:3 m:0  integer_less.inc
FBD32: .DB  0x0A, 0x2E                                    //f:2 m:0  port_D.inc
FBD33: .DB  0x2E, 0x2F                                    //f:2 m:0  logic_not.inc
FBD34: .DB  0x83, 0x03                                    //f:2 m:0  time_counter_milliseconds.inc
FBD35: .DB  0x0D, 0xB8, 0x0B, 0x30                        //f:4 m:3  time_TON.inc
FBD36: .DB  0x0B, 0x06                                    //f:2 m:4  real_Int16ToSingl.inc
FBD37: .DB  0x06, 0x09, 0x07, 0x00                        //f:3 m:4  real_mul.inc
FBD38: .DB  0x07, 0x0A, 0x08, 0x00                        //f:3 m:4  real_sub.inc
FBD39: .DB  0x08, 0x01, 0x03, 0x00                        //f:3 m:0  LCD_out_real.inc
FBD40: .DB  0x0E, 0x11, 0x0F, 0x00                        //f:3 m:4  real_mul.inc
FBD41: .DB  0x0F, 0x12, 0x10, 0x00                        //f:3 m:4  real_sub.inc
FBD42: .DB  0x10, 0x11, 0x03, 0x00                        //f:3 m:0  LCD_out_real.inc
FBD43: .DB  0x30, 0x13                                    //f:2 m:0  logic_not.inc
FBD44: .DB  0x1A, 0x14                                    //f:2 m:4  real_Int16ToSingl.inc
FBD45: .DB  0x14, 0x17, 0x15, 0x00                        //f:3 m:4  real_mul.inc
FBD46: .DB  0x15, 0x18, 0x16, 0x00                        //f:3 m:4  real_sub.inc
FBD47: .DB  0x16, 0x05, 0x03, 0x00                        //f:3 m:0  LCD_out_real.inc
FBD48: .DB  0x1A, 0x1B, 0x19, 0x00                        //f:3 m:0  integer_less.inc
FBD49: .DB  0x20, 0x1E, 0x1C, 0x00                        //f:3 m:4  real_mul.inc
FBD50: .DB  0x1C, 0x1F, 0x1D, 0x00                        //f:3 m:4  real_sub.inc
FBD51: .DB  0x1D, 0x15, 0x03, 0x00                        //f:3 m:0  LCD_out_real.inc
FBD52: .DB  0x26, 0x21                                    //f:2 m:4  real_Int16ToSingl.inc
FBD53: .DB  0x21, 0x24, 0x22, 0x00                        //f:3 m:4  real_mul.inc
FBD54: .DB  0x22, 0x25, 0x23, 0x00                        //f:3 m:4  real_sub.inc
FBD55: .DB  0x23, 0x09, 0x03, 0x00                        //f:3 m:0  LCD_out_real.inc
FBD56: .DB  0x2C, 0x2B                                    //f:2 m:4  real_Int16ToSingl.inc
FBD57: .DB  0x0C, 0x30                                    //f:2 m:0  port_D.inc
FBD58: .DB  0x09, 0x19                                    //f:2 m:0  port_D.inc
FBD59: .DB  0x19, 0x2D                                    //f:2 m:0  logic_not.inc
FBD60: .DB  0x0E, 0x2F                                    //f:2 m:0  port_D.inc
FBD61: .DB  0x08, 0x13                                    //f:2 m:0  port_D.inc
FBD62: .DB  0x2B, 0x29, 0x27, 0x00                        //f:3 m:4  real_mul.inc
FBD63: .DB  0x27, 0x2A, 0x28, 0x00                        //f:3 m:4  real_sub.inc
FBD64: .DB  0x28, 0x19, 0x03, 0x00                        //f:3 m:0  LCD_out_real.inc
FBD65: .DB  0x0D, 0x2D                                    //f:2 m:0  port_D.inc
//=====================================   kernel.inc   =====================================


.MACRO Clear_All_Memory
//************    *******************
   ldi   XL, Low(SRAM_START)                  ;    
   ldi   XH, High(SRAM_START)                 ;    

.if SRAM_SIZE>255
   ldi   YL, Low(SRAM_SIZE)                   ;   
   ldi   YH, High(SRAM_SIZE)                  ;   
Initial_Memory:
   ST    X+, Zero                             ; 
   sbiw  Y,  1                                ; 
   brne  Initial_Memory                       ;  
.else 
   ldi   YL, SRAM_SIZE                        ;   
Initial_Memory:
   ST    X+, Zero                             ; 
   dec   YL                                   ; 
   brne  Initial_Memory                       ;  
.endif
.ENDMACRO

Read_cfg:	
        mov ZL, YL
        mov ZH, YH
        lpm 
	ADIW  YL, 1           ;  
	RET

//=========================     ======================
  .MACRO Get_Flash_Pointer                           ;  
     lpm                                             ;  
	 ADIW  ZL, 1                                     ;  
	 mov   Kern_A, Addr_Data 
     lpm                                             ;  
	 mov   ZH, Addr_Data                    ;  
	 mov   ZL, Kern_A                       ;            
  .ENDMACRO 

  .MACRO Get_Flash_Byte                              ;  
     lpm                                             ;  flash
	 ADIW  ZL, 1                                     ;  
	 mov   @0, Addr_Data                             ;  flash          
  .ENDMACRO 



//============================   =========================
Read_cfg_Set_Bit_Reg_A:
 rcall Read_cfg                       ;  
Set_Bit_Reg_A:
 ldi   A, 0b000000001
 sbrc  Addr_Data, 0
 lsl   A
 sbrc  Addr_Data, 1
 lsl   A
 sbrc  Addr_Data, 1
 lsl   A
 sbrc  Addr_Data, 2
 swap  A
ret


.MACRO Set_Adr_Uzl                     ;     
  ldi   ZL, Low(FBD_DATA_RAM)   ;    
  ldi   ZH, High(FBD_DATA_RAM)  ;   
  add   ZL, @0                ;  
  adc   ZH, Zero              ;  
  add   ZL, @0                ;  
  adc   ZH, Zero              ;            
.ENDMACRO   

Set_Adres_Uzl:
  ldi   ZL, Low(FBD_DATA_RAM)   ;    
  ldi   ZH, High(FBD_DATA_RAM)  ;   
  add   ZL, Addr_Data         ;  
  adc   ZH, Zero              ;  
  add   ZL, Addr_Data         ;  
  adc   ZH, Zero              ;             
ret;

Read_Cfg_Load_Uz1:
 rcall Read_cfg                       ;  
Load_Uz1:
 rcall Set_Adres_Uzl;  //Set_Adr_Uzl Addr_Data                ;     
 ld    Uz1L, Z+                       ;  
 ld    Uz1H, Z+                       ;  
ret

Read_Cfg_Load_Uz2:
 rcall Read_cfg                       ;  
Load_Uz2:
 rcall Set_Adres_Uzl;  //Set_Adr_Uzl Addr_Data                ;     
 ld    Uz2L, Z+                       ;  
 ld    Uz2H, Z+                       ;  
ret

Read_Cfg_Load_Uz3:
 rcall Read_cfg                       ;  
Load_Uz3:
 rcall Set_Adres_Uzl;  // Set_Adr_Uzl Addr_Data                ;     
 ld    Uz3L, Z+                       ;  
 ld    Uz3H, Z+                       ;  
ret

Read_Cfg_Save_Uz1:
 rcall Read_cfg                       ;  
Save_Uz1:
 rcall Set_Adres_Uzl;  // Set_Adr_Uzl Addr_Data                ;     
 st    Z+, Uz1L                       ;  
 st    Z+, Uz1H                       ;  
ret

Read_Cfg_Save_Uz2:
 rcall Read_cfg                       ;  
Save_Uz2:
 rcall Set_Adres_Uzl;  // Set_Adr_Uzl Addr_Data                ;     
 st    Z+, Uz2L                       ;  
 st    Z+, Uz2H                       ;  
ret

Read_Cfg_Save_Uz3:
 rcall Read_cfg                       ;  
Save_Uz3:
 rcall Set_Adres_Uzl;  // Set_Adr_Uzl Addr_Data                ;     
 st    Z+, Uz3L                       ;  
 st    Z+, Uz3H                       ;  
ret

//==============================  End kernel function ==============================================


 load_cfg:
.if RAMEND>=256
   ldi   A,  Low(RAMEND)      //   
   out   SPL, A              
   ldi   A, High(RAMEND)      //   
   out   SPH, A              
.else
   ldi   A, RAMEND            //   
   out   SPL, A              
.endif   

   clr   Zero                  //
   mov   One, Zero             // 1
   inc   One                   // 1
   Clear_All_Memory            //  
   sei 
//========= init cycle ==========
ldi   XL, Low(FBD_DATA_RAM+100)          //    
ldi   XH, High(FBD_DATA_RAM+100)         //    
ldi   YL, Low(FBD0*2)                    //   flash 
ldi   YH, High(FBD0*2)                   //   flash 
rcall FBD0_init                     //LCD_hd44780_2x16.inc (0,00100010,00101100,00010000,00000001,00000100,00001100,"-            TEM","-            LIM",0,1,2,3,4,5)
ldi   YL, Low(FBD1*2)                    //   flash 
ldi   YH, High(FBD1*2)                   //   flash 
rcall FBD1_init                     //port_B.inc (1,8,3)
ldi   YL, Low(FBD2*2)                    //   flash 
ldi   YH, High(FBD2*2)                   //   flash 
rcall FBD1_init                     //port_B.inc (1,9,2)
ldi   YL, Low(FBD3*2)                    //   flash 
ldi   YH, High(FBD3*2)                   //   flash 
rcall FBD1_init                     //port_B.inc (1,10,1)
ldi   YL, Low(FBD4*2)                    //   flash 
ldi   YH, High(FBD4*2)                   //   flash 
rcall FBD1_init                     //port_B.inc (1,11,0)
ldi   YL, Low(FBD5*2)                    //   flash 
ldi   YH, High(FBD5*2)                   //   flash 
rcall FBD1_init                     //port_B.inc (1,12,5)
ldi   YL, Low(FBD6*2)                    //   flash 
ldi   YH, High(FBD6*2)                   //   flash 
rcall FBD1_init                     //port_B.inc (1,13,4)
ldi   YL, Low(FBD7*2)                    //   flash 
ldi   YH, High(FBD7*2)                   //   flash 
rcall FBD2_init                     //ADC_ATmega8a_v1_conf.inc (2,10000000,01000000)
ldi   XL, Low(FBD_DATA_RAM+102)          //    
ldi   XH, High(FBD_DATA_RAM+102)         //    
ldi   YL, Low(FBD8*2)                    //   flash 
ldi   YH, High(FBD8*2)                   //   flash 
rcall FBD3_init                     //real_const.inc (3,0.490000009536743,9)
ldi   XL, Low(FBD_DATA_RAM+106)          //    
ldi   XH, High(FBD_DATA_RAM+106)         //    
ldi   YL, Low(FBD9*2)                    //   flash 
ldi   YH, High(FBD9*2)                   //   flash 
rcall FBD3_init                     //real_const.inc (3,0,10)
ldi   YL, Low(FBD10*2)                   //   flash 
ldi   YH, High(FBD10*2)                  //   flash 
rcall FBD4_init                     //ADC_ATmega8a_v1_pin.inc (4,11,0)
ldi   YL, Low(FBD11*2)                   //   flash 
ldi   YH, High(FBD11*2)                  //   flash 
rcall FBD4_init                     //ADC_ATmega8a_v1_pin.inc (4,12,1)
ldi   XL, Low(FBD_DATA_RAM+114)          //    
ldi   XH, High(FBD_DATA_RAM+114)         //    
ldi   YL, Low(FBD14*2)                   //   flash 
ldi   YH, High(FBD14*2)                  //   flash 
rcall FBD3_init                     //real_const.inc (3,0.490000009536743,17)
ldi   XL, Low(FBD_DATA_RAM+118)          //    
ldi   XH, High(FBD_DATA_RAM+118)         //    
ldi   YL, Low(FBD15*2)                   //   flash 
ldi   YH, High(FBD15*2)                  //   flash 
rcall FBD3_init                     //real_const.inc (3,0,18)
ldi   XL, Low(FBD_DATA_RAM+122)          //    
ldi   XH, High(FBD_DATA_RAM+122)         //    
ldi   YL, Low(FBD17*2)                   //   flash 
ldi   YH, High(FBD17*2)                  //   flash 
rcall FBD3_init                     //real_const.inc (3,0.490000009536743,23)
ldi   XL, Low(FBD_DATA_RAM+126)          //    
ldi   XH, High(FBD_DATA_RAM+126)         //    
ldi   YL, Low(FBD18*2)                   //   flash 
ldi   YH, High(FBD18*2)                  //   flash 
rcall FBD3_init                     //real_const.inc (3,0,24)
ldi   YL, Low(FBD19*2)                   //   flash 
ldi   YH, High(FBD19*2)                  //   flash 
rcall FBD4_init                     //ADC_ATmega8a_v1_pin.inc (4,26,2)
ldi   YL, Low(FBD20*2)                   //   flash 
ldi   YH, High(FBD20*2)                  //   flash 
rcall FBD4_init                     //ADC_ATmega8a_v1_pin.inc (4,27,3)
ldi   XL, Low(FBD_DATA_RAM+130)          //    
ldi   XH, High(FBD_DATA_RAM+130)         //    
ldi   YL, Low(FBD21*2)                   //   flash 
ldi   YH, High(FBD21*2)                  //   flash 
rcall FBD3_init                     //real_const.inc (3,0.490000009536743,30)
ldi   XL, Low(FBD_DATA_RAM+134)          //    
ldi   XH, High(FBD_DATA_RAM+134)         //    
ldi   YL, Low(FBD22*2)                   //   flash 
ldi   YH, High(FBD22*2)                  //   flash 
rcall FBD3_init                     //real_const.inc (3,0,31)
ldi   XL, Low(FBD_DATA_RAM+142)          //    
ldi   XH, High(FBD_DATA_RAM+142)         //    
ldi   YL, Low(FBD24*2)                   //   flash 
ldi   YH, High(FBD24*2)                  //   flash 
rcall FBD3_init                     //real_const.inc (3,0.490000009536743,36)
ldi   XL, Low(FBD_DATA_RAM+146)          //    
ldi   XH, High(FBD_DATA_RAM+146)         //    
ldi   YL, Low(FBD25*2)                   //   flash 
ldi   YH, High(FBD25*2)                  //   flash 
rcall FBD3_init                     //real_const.inc (3,0,37)
ldi   YL, Low(FBD26*2)                   //   flash 
ldi   YH, High(FBD26*2)                  //   flash 
rcall FBD4_init                     //ADC_ATmega8a_v1_pin.inc (4,38,4)
ldi   XL, Low(FBD_DATA_RAM+150)          //    
ldi   XH, High(FBD_DATA_RAM+150)         //    
ldi   YL, Low(FBD27*2)                   //   flash 
ldi   YH, High(FBD27*2)                  //   flash 
rcall FBD3_init                     //real_const.inc (3,0.490000009536743,41)
ldi   XL, Low(FBD_DATA_RAM+154)          //    
ldi   XH, High(FBD_DATA_RAM+154)         //    
ldi   YL, Low(FBD28*2)                   //   flash 
ldi   YH, High(FBD28*2)                  //   flash 
rcall FBD3_init                     //real_const.inc (3,0,42)
ldi   YL, Low(FBD29*2)                   //   flash 
ldi   YH, High(FBD29*2)                  //   flash 
rcall FBD4_init                     //ADC_ATmega8a_v1_pin.inc (4,44,5)
ldi   YL, Low(FBD30*2)                   //   flash 
ldi   YH, High(FBD30*2)                  //   flash 
rcall FBD8_init                     //time_counter_milliseconds.inc (8,899)
ldi   YL, Low(FBD32*2)                   //   flash 
ldi   YH, High(FBD32*2)                  //   flash 
rcall FBD9_init                     //port_D.inc (9,10,46)
ldi   YL, Low(FBD34*2)                   //   flash 
ldi   YH, High(FBD34*2)                  //   flash 
rcall FBD8_init                     //time_counter_milliseconds.inc (8,899)
ldi   YL, Low(FBD57*2)                   //   flash 
ldi   YH, High(FBD57*2)                  //   flash 
rcall FBD9_init                     //port_D.inc (9,12,48)
ldi   YL, Low(FBD58*2)                   //   flash 
ldi   YH, High(FBD58*2)                  //   flash 
rcall FBD9_init                     //port_D.inc (9,9,25)
ldi   YL, Low(FBD60*2)                   //   flash 
ldi   YH, High(FBD60*2)                  //   flash 
rcall FBD9_init                     //port_D.inc (9,14,47)
ldi   YL, Low(FBD61*2)                   //   flash 
ldi   YH, High(FBD61*2)                  //   flash 
rcall FBD9_init                     //port_D.inc (9,8,19)
ldi   YL, Low(FBD65*2)                   //   flash 
ldi   YH, High(FBD65*2)                  //   flash 
rcall FBD9_init                     //port_D.inc (9,13,45)
//========= run cycle ==========
Run_FBD:       //main cycle
ldi   XL, Low(FBD_DATA_RAM+100)          //    
ldi   XH, High(FBD_DATA_RAM+100)         //    
ldi   YL, Low(FBD0*2)                    //   flash 
ldi   YH, High(FBD0*2)                   //   flash 
rcall FBD0_run                      //LCD_hd44780_2x16.inc (0,00100010,00101100,00010000,00000001,00000100,00001100,"-            TEM","-            LIM",0,1,2,3,4,5)
ldi   YL, Low(FBD1*2)                    //   flash 
ldi   YH, High(FBD1*2)                   //   flash 
rcall FBD1_run                      //port_B.inc (1,8,3)
ldi   YL, Low(FBD2*2)                    //   flash 
ldi   YH, High(FBD2*2)                   //   flash 
rcall FBD1_run                      //port_B.inc (1,9,2)
ldi   YL, Low(FBD3*2)                    //   flash 
ldi   YH, High(FBD3*2)                   //   flash 
rcall FBD1_run                      //port_B.inc (1,10,1)
ldi   YL, Low(FBD4*2)                    //   flash 
ldi   YH, High(FBD4*2)                   //   flash 
rcall FBD1_run                      //port_B.inc (1,11,0)
ldi   YL, Low(FBD5*2)                    //   flash 
ldi   YH, High(FBD5*2)                   //   flash 
rcall FBD1_run                      //port_B.inc (1,12,5)
ldi   YL, Low(FBD6*2)                    //   flash 
ldi   YH, High(FBD6*2)                   //   flash 
rcall FBD1_run                      //port_B.inc (1,13,4)
ldi   YL, Low(FBD7*2)                    //   flash 
ldi   YH, High(FBD7*2)                   //   flash 
rcall FBD2_run                      //ADC_ATmega8a_v1_conf.inc (2,10000000,01000000)
ldi   XL, Low(FBD_DATA_RAM+102)          //    
ldi   XH, High(FBD_DATA_RAM+102)         //    
ldi   YL, Low(FBD8*2)                    //   flash 
ldi   YH, High(FBD8*2)                   //   flash 
rcall FBD3_run                      //real_const.inc (3,0.490000009536743,9)
ldi   XL, Low(FBD_DATA_RAM+106)          //    
ldi   XH, High(FBD_DATA_RAM+106)         //    
ldi   YL, Low(FBD9*2)                    //   flash 
ldi   YH, High(FBD9*2)                   //   flash 
rcall FBD3_run                      //real_const.inc (3,0,10)
ldi   YL, Low(FBD10*2)                   //   flash 
ldi   YH, High(FBD10*2)                  //   flash 
rcall FBD4_run                      //ADC_ATmega8a_v1_pin.inc (4,11,0)
ldi   YL, Low(FBD11*2)                   //   flash 
ldi   YH, High(FBD11*2)                  //   flash 
rcall FBD4_run                      //ADC_ATmega8a_v1_pin.inc (4,12,1)
ldi   YL, Low(FBD12*2)                   //   flash 
ldi   YH, High(FBD12*2)                  //   flash 
rcall FBD5_run                      //integer_less.inc (5,11,12,13)
ldi   XL, Low(FBD_DATA_RAM+110)          //    
ldi   XH, High(FBD_DATA_RAM+110)         //    
ldi   YL, Low(FBD13*2)                   //   flash 
ldi   YH, High(FBD13*2)                  //   flash 
rcall FBD6_run                      //real_Int16ToSingl.inc (6,12,14)
ldi   XL, Low(FBD_DATA_RAM+114)          //    
ldi   XH, High(FBD_DATA_RAM+114)         //    
ldi   YL, Low(FBD14*2)                   //   flash 
ldi   YH, High(FBD14*2)                  //   flash 
rcall FBD3_run                      //real_const.inc (3,0.490000009536743,17)
ldi   XL, Low(FBD_DATA_RAM+118)          //    
ldi   XH, High(FBD_DATA_RAM+118)         //    
ldi   YL, Low(FBD15*2)                   //   flash 
ldi   YH, High(FBD15*2)                  //   flash 
rcall FBD3_run                      //real_const.inc (3,0,18)
ldi   YL, Low(FBD16*2)                   //   flash 
ldi   YH, High(FBD16*2)                  //   flash 
rcall FBD7_run                      //const.inc (7,3,49)
ldi   XL, Low(FBD_DATA_RAM+122)          //    
ldi   XH, High(FBD_DATA_RAM+122)         //    
ldi   YL, Low(FBD17*2)                   //   flash 
ldi   YH, High(FBD17*2)                  //   flash 
rcall FBD3_run                      //real_const.inc (3,0.490000009536743,23)
ldi   XL, Low(FBD_DATA_RAM+126)          //    
ldi   XH, High(FBD_DATA_RAM+126)         //    
ldi   YL, Low(FBD18*2)                   //   flash 
ldi   YH, High(FBD18*2)                  //   flash 
rcall FBD3_run                      //real_const.inc (3,0,24)
ldi   YL, Low(FBD19*2)                   //   flash 
ldi   YH, High(FBD19*2)                  //   flash 
rcall FBD4_run                      //ADC_ATmega8a_v1_pin.inc (4,26,2)
ldi   YL, Low(FBD20*2)                   //   flash 
ldi   YH, High(FBD20*2)                  //   flash 
rcall FBD4_run                      //ADC_ATmega8a_v1_pin.inc (4,27,3)
ldi   XL, Low(FBD_DATA_RAM+130)          //    
ldi   XH, High(FBD_DATA_RAM+130)         //    
ldi   YL, Low(FBD21*2)                   //   flash 
ldi   YH, High(FBD21*2)                  //   flash 
rcall FBD3_run                      //real_const.inc (3,0.490000009536743,30)
ldi   XL, Low(FBD_DATA_RAM+134)          //    
ldi   XH, High(FBD_DATA_RAM+134)         //    
ldi   YL, Low(FBD22*2)                   //   flash 
ldi   YH, High(FBD22*2)                  //   flash 
rcall FBD3_run                      //real_const.inc (3,0,31)
ldi   XL, Low(FBD_DATA_RAM+138)          //    
ldi   XH, High(FBD_DATA_RAM+138)         //    
ldi   YL, Low(FBD23*2)                   //   flash 
ldi   YH, High(FBD23*2)                  //   flash 
rcall FBD6_run                      //real_Int16ToSingl.inc (6,27,32)
ldi   XL, Low(FBD_DATA_RAM+142)          //    
ldi   XH, High(FBD_DATA_RAM+142)         //    
ldi   YL, Low(FBD24*2)                   //   flash 
ldi   YH, High(FBD24*2)                  //   flash 
rcall FBD3_run                      //real_const.inc (3,0.490000009536743,36)
ldi   XL, Low(FBD_DATA_RAM+146)          //    
ldi   XH, High(FBD_DATA_RAM+146)         //    
ldi   YL, Low(FBD25*2)                   //   flash 
ldi   YH, High(FBD25*2)                  //   flash 
rcall FBD3_run                      //real_const.inc (3,0,37)
ldi   YL, Low(FBD26*2)                   //   flash 
ldi   YH, High(FBD26*2)                  //   flash 
rcall FBD4_run                      //ADC_ATmega8a_v1_pin.inc (4,38,4)
ldi   XL, Low(FBD_DATA_RAM+150)          //    
ldi   XH, High(FBD_DATA_RAM+150)         //    
ldi   YL, Low(FBD27*2)                   //   flash 
ldi   YH, High(FBD27*2)                  //   flash 
rcall FBD3_run                      //real_const.inc (3,0.490000009536743,41)
ldi   XL, Low(FBD_DATA_RAM+154)          //    
ldi   XH, High(FBD_DATA_RAM+154)         //    
ldi   YL, Low(FBD28*2)                   //   flash 
ldi   YH, High(FBD28*2)                  //   flash 
rcall FBD3_run                      //real_const.inc (3,0,42)
ldi   YL, Low(FBD29*2)                   //   flash 
ldi   YH, High(FBD29*2)                  //   flash 
rcall FBD4_run                      //ADC_ATmega8a_v1_pin.inc (4,44,5)
ldi   YL, Low(FBD30*2)                   //   flash 
ldi   YH, High(FBD30*2)                  //   flash 
rcall FBD8_run                      //time_counter_milliseconds.inc (8,899)
ldi   YL, Low(FBD31*2)                   //   flash 
ldi   YH, High(FBD31*2)                  //   flash 
rcall FBD5_run                      //integer_less.inc (5,38,44,46)
ldi   YL, Low(FBD32*2)                   //   flash 
ldi   YH, High(FBD32*2)                  //   flash 
rcall FBD9_run                      //port_D.inc (9,10,46)
ldi   YL, Low(FBD33*2)                   //   flash 
ldi   YH, High(FBD33*2)                  //   flash 
rcall FBD10_run                     //logic_not.inc (10,46,47)
ldi   YL, Low(FBD34*2)                   //   flash 
ldi   YH, High(FBD34*2)                  //   flash 
rcall FBD8_run                      //time_counter_milliseconds.inc (8,899)
ldi   XL, Low(FBD_DATA_RAM+158)          //    
ldi   XH, High(FBD_DATA_RAM+158)         //    
ldi   YL, Low(FBD35*2)                   //   flash 
ldi   YH, High(FBD35*2)                  //   flash 
rcall FBD11_run                     //time_TON.inc (11,13,3000,48)
ldi   XL, Low(FBD_DATA_RAM+161)          //    
ldi   XH, High(FBD_DATA_RAM+161)         //    
ldi   YL, Low(FBD36*2)                   //   flash 
ldi   YH, High(FBD36*2)                  //   flash 
rcall FBD6_run                      //real_Int16ToSingl.inc (6,11,6)
ldi   XL, Low(FBD_DATA_RAM+165)          //    
ldi   XH, High(FBD_DATA_RAM+165)         //    
ldi   YL, Low(FBD37*2)                   //   flash 
ldi   YH, High(FBD37*2)                  //   flash 
rcall FBD12_run                     //real_mul.inc (12,6,9,7)
ldi   XL, Low(FBD_DATA_RAM+169)          //    
ldi   XH, High(FBD_DATA_RAM+169)         //    
ldi   YL, Low(FBD38*2)                   //   flash 
ldi   YH, High(FBD38*2)                  //   flash 
rcall FBD13_run                     //real_sub.inc (13,7,10,8)
ldi   YL, Low(FBD39*2)                   //   flash 
ldi   YH, High(FBD39*2)                  //   flash 
rcall FBD14_run                     //LCD_out_real.inc (14,8,1,3)
ldi   XL, Low(FBD_DATA_RAM+173)          //    
ldi   XH, High(FBD_DATA_RAM+173)         //    
ldi   YL, Low(FBD40*2)                   //   flash 
ldi   YH, High(FBD40*2)                  //   flash 
rcall FBD12_run                     //real_mul.inc (12,14,17,15)
ldi   XL, Low(FBD_DATA_RAM+177)          //    
ldi   XH, High(FBD_DATA_RAM+177)         //    
ldi   YL, Low(FBD41*2)                   //   flash 
ldi   YH, High(FBD41*2)                  //   flash 
rcall FBD13_run                     //real_sub.inc (13,15,18,16)
ldi   YL, Low(FBD42*2)                   //   flash 
ldi   YH, High(FBD42*2)                  //   flash 
rcall FBD14_run                     //LCD_out_real.inc (14,16,17,3)
ldi   YL, Low(FBD43*2)                   //   flash 
ldi   YH, High(FBD43*2)                  //   flash 
rcall FBD10_run                     //logic_not.inc (10,48,19)
ldi   XL, Low(FBD_DATA_RAM+181)          //    
ldi   XH, High(FBD_DATA_RAM+181)         //    
ldi   YL, Low(FBD44*2)                   //   flash 
ldi   YH, High(FBD44*2)                  //   flash 
rcall FBD6_run                      //real_Int16ToSingl.inc (6,26,20)
ldi   XL, Low(FBD_DATA_RAM+185)          //    
ldi   XH, High(FBD_DATA_RAM+185)         //    
ldi   YL, Low(FBD45*2)                   //   flash 
ldi   YH, High(FBD45*2)                  //   flash 
rcall FBD12_run                     //real_mul.inc (12,20,23,21)
ldi   XL, Low(FBD_DATA_RAM+189)          //    
ldi   XH, High(FBD_DATA_RAM+189)         //    
ldi   YL, Low(FBD46*2)                   //   flash 
ldi   YH, High(FBD46*2)                  //   flash 
rcall FBD13_run                     //real_sub.inc (13,21,24,22)
ldi   YL, Low(FBD47*2)                   //   flash 
ldi   YH, High(FBD47*2)                  //   flash 
rcall FBD14_run                     //LCD_out_real.inc (14,22,5,3)
ldi   YL, Low(FBD48*2)                   //   flash 
ldi   YH, High(FBD48*2)                  //   flash 
rcall FBD5_run                      //integer_less.inc (5,26,27,25)
ldi   XL, Low(FBD_DATA_RAM+193)          //    
ldi   XH, High(FBD_DATA_RAM+193)         //    
ldi   YL, Low(FBD49*2)                   //   flash 
ldi   YH, High(FBD49*2)                  //   flash 
rcall FBD12_run                     //real_mul.inc (12,32,30,28)
ldi   XL, Low(FBD_DATA_RAM+197)          //    
ldi   XH, High(FBD_DATA_RAM+197)         //    
ldi   YL, Low(FBD50*2)                   //   flash 
ldi   YH, High(FBD50*2)                  //   flash 
rcall FBD13_run                     //real_sub.inc (13,28,31,29)
ldi   YL, Low(FBD51*2)                   //   flash 
ldi   YH, High(FBD51*2)                  //   flash 
rcall FBD14_run                     //LCD_out_real.inc (14,29,21,3)
ldi   XL, Low(FBD_DATA_RAM+201)          //    
ldi   XH, High(FBD_DATA_RAM+201)         //    
ldi   YL, Low(FBD52*2)                   //   flash 
ldi   YH, High(FBD52*2)                  //   flash 
rcall FBD6_run                      //real_Int16ToSingl.inc (6,38,33)
ldi   XL, Low(FBD_DATA_RAM+205)          //    
ldi   XH, High(FBD_DATA_RAM+205)         //    
ldi   YL, Low(FBD53*2)                   //   flash 
ldi   YH, High(FBD53*2)                  //   flash 
rcall FBD12_run                     //real_mul.inc (12,33,36,34)
ldi   XL, Low(FBD_DATA_RAM+209)          //    
ldi   XH, High(FBD_DATA_RAM+209)         //    
ldi   YL, Low(FBD54*2)                   //   flash 
ldi   YH, High(FBD54*2)                  //   flash 
rcall FBD13_run                     //real_sub.inc (13,34,37,35)
ldi   YL, Low(FBD55*2)                   //   flash 
ldi   YH, High(FBD55*2)                  //   flash 
rcall FBD14_run                     //LCD_out_real.inc (14,35,9,3)
ldi   XL, Low(FBD_DATA_RAM+213)          //    
ldi   XH, High(FBD_DATA_RAM+213)         //    
ldi   YL, Low(FBD56*2)                   //   flash 
ldi   YH, High(FBD56*2)                  //   flash 
rcall FBD6_run                      //real_Int16ToSingl.inc (6,44,43)
ldi   YL, Low(FBD57*2)                   //   flash 
ldi   YH, High(FBD57*2)                  //   flash 
rcall FBD9_run                      //port_D.inc (9,12,48)
ldi   YL, Low(FBD58*2)                   //   flash 
ldi   YH, High(FBD58*2)                  //   flash 
rcall FBD9_run                      //port_D.inc (9,9,25)
ldi   YL, Low(FBD59*2)                   //   flash 
ldi   YH, High(FBD59*2)                  //   flash 
rcall FBD10_run                     //logic_not.inc (10,25,45)
ldi   YL, Low(FBD60*2)                   //   flash 
ldi   YH, High(FBD60*2)                  //   flash 
rcall FBD9_run                      //port_D.inc (9,14,47)
ldi   YL, Low(FBD61*2)                   //   flash 
ldi   YH, High(FBD61*2)                  //   flash 
rcall FBD9_run                      //port_D.inc (9,8,19)
ldi   XL, Low(FBD_DATA_RAM+217)          //    
ldi   XH, High(FBD_DATA_RAM+217)         //    
ldi   YL, Low(FBD62*2)                   //   flash 
ldi   YH, High(FBD62*2)                  //   flash 
rcall FBD12_run                     //real_mul.inc (12,43,41,39)
ldi   XL, Low(FBD_DATA_RAM+221)          //    
ldi   XH, High(FBD_DATA_RAM+221)         //    
ldi   YL, Low(FBD63*2)                   //   flash 
ldi   YH, High(FBD63*2)                  //   flash 
rcall FBD13_run                     //real_sub.inc (13,39,42,40)
ldi   YL, Low(FBD64*2)                   //   flash 
ldi   YH, High(FBD64*2)                  //   flash 
rcall FBD14_run                     //LCD_out_real.inc (14,40,25,3)
ldi   YL, Low(FBD65*2)                   //   flash 
ldi   YH, High(FBD65*2)                  //   flash 
rcall FBD9_run                      //port_D.inc (9,13,45)
rjmp  Run_FBD
.DSEG
RAM_global: .BYTE FBD_DATA_RAM-SRAM_START
RAM_uzel:   .BYTE 100
RAM_FBD:    .BYTE 125
RAM_stack:  .BYTE 8
